/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpHeaderTenantResolverConfiguration;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

@Singleton
@Requirements(value={@Requires(beans={HttpHeaderTenantResolverConfiguration.class}), @Requires(property="micronaut.multitenancy.tenantresolver.httpheader.enabled", value="true", defaultValue="false")})
public class HttpHeaderTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    protected String headerName = "tenantId";

    public HttpHeaderTenantResolver(HttpHeaderTenantResolverConfiguration configuration) {
        if (configuration != null) {
            this.headerName = configuration.getHeaderName();
        }
    }

    @Override
    @NonNull
    public String resolveTenantId() throws TenantNotFoundException {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantId).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public String resolveTenantId(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        String tenantId = (String)Objects.requireNonNull(request, "request must not be null").getHeaders().get((CharSequence)this.headerName);
        if (tenantId == null) {
            throw new TenantNotFoundException("Tenant could not be resolved. Header " + this.headerName + " value is null");
        }
        return tenantId;
    }

    @Override
    @Deprecated(forRemoval=true, since="5.5.0")
    @NonNull
    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        return this.resolveTenantId();
    }

    @Override
    @Deprecated(forRemoval=true, since="5.5.0")
    public Serializable resolveTenantIdentifier(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        return this.resolveTenantId(request);
    }
}

