/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.nats.bind.NatsAnnotatedArgumentBinder;
import io.micronaut.nats.bind.NatsArgumentBinder;
import io.micronaut.nats.bind.NatsDefaultBinder;
import io.nats.client.Message;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@Singleton
public class NatsBinderRegistry
implements ArgumentBinderRegistry<Message> {
    private final Map<Class<? extends Annotation>, ArgumentBinder<?, Message>> byAnnotation = new LinkedHashMap();
    private final NatsDefaultBinder defaultBinder;

    public NatsBinderRegistry(NatsDefaultBinder defaultBinder, NatsArgumentBinder ... binders) {
        this.defaultBinder = defaultBinder;
        if (ArrayUtils.isNotEmpty((Object[])binders)) {
            for (NatsArgumentBinder binder : binders) {
                if (!(binder instanceof NatsAnnotatedArgumentBinder)) continue;
                NatsAnnotatedArgumentBinder annotatedBinder = (NatsAnnotatedArgumentBinder)binder;
                this.byAnnotation.put(annotatedBinder.getAnnotationType(), binder);
            }
        }
    }

    public <T> Optional<ArgumentBinder<T, Message>> findArgumentBinder(Argument<T> argument, Message source) {
        Class annotationType;
        ArgumentBinder<?, Message> binder;
        Optional opt = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (opt.isPresent() && (binder = this.byAnnotation.get(annotationType = (Class)opt.get())) != null) {
            return Optional.of(binder);
        }
        return Optional.of(this.defaultBinder);
    }
}

