/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.messaging.annotation.MessageBody;
import io.micronaut.nats.bind.NatsAnnotatedArgumentBinder;
import io.micronaut.nats.serdes.NatsMessageSerDesRegistry;
import io.nats.client.Message;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class NatsBodyBinder
implements NatsAnnotatedArgumentBinder<MessageBody> {
    private final NatsMessageSerDesRegistry serDesRegistry;

    public NatsBodyBinder(NatsMessageSerDesRegistry serDesRegistry) {
        this.serDesRegistry = serDesRegistry;
    }

    public Class<MessageBody> getAnnotationType() {
        return MessageBody.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, Message messageState) {
        Argument bodyType = context.getArgument();
        Optional<Object> message = this.serDesRegistry.findSerdes(bodyType).map(serDes -> serDes.deserialize(messageState, bodyType));
        return () -> message;
    }
}

