/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.connect;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Nullable;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.validation.constraints.NotNull;

public abstract class NatsConnectionFactoryConfig {
    private final String name;
    private List<String> addresses = Collections.singletonList("nats://localhost:4222");
    private int maxReconnect = 60;
    private Duration reconnectWait = Options.DEFAULT_RECONNECT_WAIT;
    private Duration connectionTimeout = Options.DEFAULT_CONNECTION_TIMEOUT;
    private Duration pingInterval = Options.DEFAULT_PING_INTERVAL;
    private long reconnectBufferSize = 0x800000L;
    private String inboxPrefix = "_INBOX.";
    private boolean noEcho;
    private boolean utf8Support;
    private String username;
    private String password;
    private String token;
    private String credentials;
    private TLS tls;

    public NatsConnectionFactoryConfig(@Parameter String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<String>> getAddresses() {
        return Optional.ofNullable(this.addresses);
    }

    public void setAddresses(@Nullable List<String> addresses) {
        this.addresses = addresses;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public void setMaxReconnect(int maxReconnect) {
        this.maxReconnect = maxReconnect;
    }

    public Duration getReconnectWait() {
        return this.reconnectWait;
    }

    public void setReconnectWait(Duration reconnectWait) {
        this.reconnectWait = reconnectWait;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(Duration pingInterval) {
        this.pingInterval = pingInterval;
    }

    public long getReconnectBufferSize() {
        return this.reconnectBufferSize;
    }

    public void setReconnectBufferSize(long reconnectBufferSize) {
        this.reconnectBufferSize = reconnectBufferSize;
    }

    public String getInboxPrefix() {
        return this.inboxPrefix;
    }

    public void setInboxPrefix(String inboxPrefix) {
        this.inboxPrefix = inboxPrefix;
    }

    public boolean isNoEcho() {
        return this.noEcho;
    }

    public void setNoEcho(boolean noEcho) {
        this.noEcho = noEcho;
    }

    public boolean isUtf8Support() {
        return this.utf8Support;
    }

    public void setUtf8Support(boolean utf8Support) {
        this.utf8Support = utf8Support;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setTls(@NotNull TLS tls) {
        this.tls = tls;
    }

    public Options.Builder toOptionsBuilder() throws IOException, GeneralSecurityException {
        Options.Builder builder = new Options.Builder();
        builder = builder.servers(this.addresses.toArray(new String[0]));
        builder = builder.maxReconnects(this.maxReconnect);
        builder = builder.reconnectWait(this.reconnectWait);
        builder = builder.connectionTimeout(this.connectionTimeout);
        builder = builder.connectionName(this.name);
        builder = builder.pingInterval(this.pingInterval);
        builder = builder.reconnectBufferSize(this.reconnectBufferSize);
        builder = builder.inboxPrefix(this.inboxPrefix);
        if (this.noEcho) {
            builder = builder.noEcho();
        }
        if (this.utf8Support) {
            builder = builder.supportUTF8Subjects();
        }
        if (this.credentials != null && !this.credentials.isEmpty()) {
            builder = builder.authHandler(Nats.credentials((String)this.credentials));
        } else if (this.token != null && !this.token.isEmpty()) {
            builder = builder.token(this.token);
        } else if (this.username != null && !this.username.isEmpty()) {
            builder = builder.userInfo(this.username, this.password);
        }
        if (this.tls != null) {
            builder.sslContext(this.tls.createTlsContext());
        }
        return builder;
    }

    public static class TLS {
        private String trustStorePath;
        private String trustStorePassword;
        private String trustStoreType;
        private String certificatePath;

        public String getTrustStorePath() {
            return this.trustStorePath;
        }

        public void setTrustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public void setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
        }

        public String getCertificatePath() {
            return this.certificatePath;
        }

        public void setCertificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
        }

        private SSLContext createTlsContext() throws IOException, GeneralSecurityException {
            Throwable throwable;
            BufferedInputStream in;
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory factory = TrustManagerFactory.getInstance(Optional.ofNullable(this.trustStoreType).orElse("SunX509"));
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            if (this.trustStorePath != null && !this.trustStorePath.isEmpty()) {
                in = new BufferedInputStream(new FileInputStream(this.trustStorePath));
                throwable = null;
                try {
                    ks.load(in, Optional.ofNullable(this.trustStorePassword).map(String::toCharArray).orElse(new char[0]));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            } else {
                ks.load(null);
            }
            if (this.certificatePath != null && !this.certificatePath.isEmpty()) {
                in = new BufferedInputStream(new FileInputStream(this.certificatePath));
                throwable = null;
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
                    ks.setCertificateEntry("nats", cert);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            factory.init(ks);
            ctx.init(null, factory.getTrustManagers(), new SecureRandom());
            return ctx;
        }
    }
}

