/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.AbstractHealthIndicator;
import io.nats.client.Connection;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;

@Requirements(value={@Requires(property="endpoints.health.nats.enabled", notEquals="false"), @Requires(beans={HealthEndpoint.class})})
@Singleton
public class NatsHealthIndicator
extends AbstractHealthIndicator<Map<String, Object>> {
    private final Connection connection;

    public NatsHealthIndicator(Connection connection) {
        this.connection = connection;
    }

    protected Map<String, Object> getHealthInformation() {
        if (this.connection.getStatus() == Connection.Status.CONNECTED) {
            this.healthStatus = HealthStatus.UP;
            return Collections.singletonMap("servers", this.connection.getServers());
        }
        this.healthStatus = HealthStatus.DOWN;
        return Collections.emptyMap();
    }

    protected String getName() {
        return "nats";
    }
}

