/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.intercept;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.DefaultExecutableBinder;
import io.micronaut.core.type.Executable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.messaging.exceptions.MessageListenerException;
import io.micronaut.nats.annotation.NatsConnection;
import io.micronaut.nats.annotation.NatsListener;
import io.micronaut.nats.annotation.Subject;
import io.micronaut.nats.bind.NatsBinderRegistry;
import io.micronaut.nats.exception.NatsListenerException;
import io.micronaut.nats.exception.NatsListenerExceptionHandler;
import io.micronaut.nats.serdes.NatsMessageSerDes;
import io.micronaut.nats.serdes.NatsMessageSerDesRegistry;
import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import jakarta.inject.Singleton;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class NatsConsumerAdvice
implements ExecutableMethodProcessor<Subject>,
AutoCloseable {
    private final BeanContext beanContext;
    private final NatsBinderRegistry binderRegistry;
    private final NatsMessageSerDesRegistry serDesRegistry;
    private final NatsListenerExceptionHandler exceptionHandler;
    private final Map<Dispatcher, String> consumerDispatchers = new ConcurrentHashMap<Dispatcher, String>();

    public NatsConsumerAdvice(BeanContext beanContext, NatsBinderRegistry binderRegistry, NatsMessageSerDesRegistry serDesRegistry, NatsListenerExceptionHandler exceptionHandler) {
        this.beanContext = beanContext;
        this.binderRegistry = binderRegistry;
        this.serDesRegistry = serDesRegistry;
        this.exceptionHandler = exceptionHandler;
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        AnnotationValue subjectAnn;
        if (method.hasAnnotation(NatsListener.class) && (subjectAnn = method.getAnnotation(Subject.class)) != null) {
            String subject = (String)subjectAnn.getRequiredValue(String.class);
            String connectionName = method.findAnnotation(NatsConnection.class).flatMap(conn -> conn.get((CharSequence)"connection", String.class)).orElse("default");
            Qualifier qualifer = beanDefinition.getAnnotationTypeByStereotype("javax.inject.Qualifier").map(type -> Qualifiers.byAnnotation((AnnotationMetadata)beanDefinition, (Class)type)).orElse(null);
            Class beanType = beanDefinition.getBeanType();
            Class returnTypeClass = method.getReturnType().getType();
            boolean isVoid = returnTypeClass == Void.class || returnTypeClass == Void.TYPE;
            Object bean = this.beanContext.findBean(beanType, qualifer).orElseThrow(() -> new MessageListenerException("Could not find the bean to execute the method " + method));
            Connection connection = (Connection)this.beanContext.getBean(Connection.class, Qualifiers.byName((String)connectionName));
            DefaultExecutableBinder binder = new DefaultExecutableBinder();
            Dispatcher ds = connection.createDispatcher(msg -> {
                BoundExecutable boundExecutable = null;
                try {
                    boundExecutable = binder.bind((Executable)method, (ArgumentBinderRegistry)this.binderRegistry, (Object)msg);
                }
                catch (Throwable e) {
                    this.handleException(new NatsListenerException("An error occurred binding the message to the method", e, bean, msg));
                }
                if (boundExecutable != null) {
                    Object returnedValue = boundExecutable.invoke(bean);
                    if (!isVoid && StringUtils.isNotEmpty((CharSequence)msg.getReplyTo())) {
                        byte[] converted = null;
                        if (returnedValue != null) {
                            NatsMessageSerDes serDes = this.serDesRegistry.findSerdes(method.getReturnType().asArgument()).map(NatsMessageSerDes.class::cast).orElseThrow(() -> new NatsListenerException(String.format("Could not find a serializer for the body argument of type [%s]", returnedValue.getClass().getName()), bean, msg));
                            converted = serDes.serialize(returnedValue);
                        }
                        connection.publish(msg.getReplyTo(), converted);
                    }
                }
            });
            Optional queueOptional = subjectAnn.get((CharSequence)"queue", String.class);
            if (queueOptional.isPresent() && !((String)queueOptional.get()).isEmpty()) {
                ds.subscribe(subject, (String)queueOptional.get());
            } else {
                ds.subscribe(subject);
            }
            this.consumerDispatchers.put(ds, subject);
        }
    }

    @Override
    public void close() {
        Iterator<Map.Entry<Dispatcher, String>> it = this.consumerDispatchers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Dispatcher, String> entry = it.next();
            Dispatcher dispatcher = entry.getKey();
            String subject = entry.getValue();
            dispatcher.unsubscribe(subject);
            if (dispatcher.isActive()) continue;
            it.remove();
        }
    }

    private void handleException(NatsListenerException exception) {
        Object bean = exception.getListener();
        if (bean instanceof NatsListenerExceptionHandler) {
            ((NatsListenerExceptionHandler)bean).handle((Throwable)((Object)exception));
        } else {
            this.exceptionHandler.handle((Throwable)((Object)exception));
        }
    }
}

