/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.nats.reactive.ReactivePublisher;
import io.micronaut.nats.serdes.NatsMessageSerDes;
import java.util.Optional;

@Internal
class StaticPublisherState {
    private final String subject;
    private final Argument bodyArgument;
    private final ReturnType<?> returnType;
    private final String connection;
    private final NatsMessageSerDes<?> serDes;
    private final Argument<?> dataType;
    private final ReactivePublisher reactivePublisher;
    private final boolean reactive;

    StaticPublisherState(String subject, Argument bodyArgument, ReturnType<?> returnType, String connection, NatsMessageSerDes<?> serDes, ReactivePublisher reactivePublisher) {
        this.subject = subject;
        this.bodyArgument = bodyArgument;
        this.connection = connection;
        this.serDes = serDes;
        this.reactivePublisher = reactivePublisher;
        Class javaReturnType = returnType.getType();
        this.reactive = Publishers.isConvertibleToPublisher((Class)javaReturnType);
        this.dataType = this.reactive ? returnType.getFirstTypeVariable().orElse(Argument.VOID) : returnType.asArgument();
        this.returnType = returnType;
    }

    Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    Argument getBodyArgument() {
        return this.bodyArgument;
    }

    Argument<?> getDataType() {
        return this.dataType;
    }

    ReturnType<?> getReturnType() {
        return this.returnType;
    }

    String getConnection() {
        return this.connection;
    }

    NatsMessageSerDes<Object> getSerDes() {
        return this.serDes;
    }

    boolean isReactive() {
        return this.reactive;
    }

    ReactivePublisher getReactivePublisher() {
        return this.reactivePublisher;
    }
}

