/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.reactive;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.nats.reactive.PublishState;
import io.micronaut.nats.reactive.ReactivePublisher;
import io.nats.client.Connection;
import io.nats.client.Message;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
@EachBean(value=Connection.class)
public class ReactorReactivePublisher
implements ReactivePublisher {
    private final Connection connection;

    public ReactorReactivePublisher(@Parameter Connection connection) {
        this.connection = connection;
    }

    @Override
    public Publisher<Void> publish(PublishState publishState) {
        return this.getConnection().flatMap(con -> this.publishInternal(publishState, (Connection)con));
    }

    private Mono<Void> publishInternal(PublishState publishState, Connection con) {
        return Mono.create(subscriber -> {
            con.publish(publishState.getSubject(), publishState.getBody());
            subscriber.success();
        });
    }

    @Override
    public Publisher<Message> publishAndReply(PublishState publishState) {
        return this.getConnection().flatMap(con -> Mono.fromFuture((CompletableFuture)con.request(publishState.getSubject(), publishState.getBody())));
    }

    private Mono<Connection> getConnection() {
        return Mono.just((Object)this.connection);
    }
}

