/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.nats.serdes.NatsMessageSerDes;
import io.nats.client.Message;
import jakarta.inject.Singleton;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

@Singleton
public class JavaLangNatsMessageSerDes
implements NatsMessageSerDes<Object> {
    public static final Integer ORDER = 100;
    protected final List<NatsMessageSerDes> javaSerDes = new ArrayList<NatsMessageSerDes>(10);

    public JavaLangNatsMessageSerDes() {
        this.javaSerDes.add(this.getStringSerDes());
        this.javaSerDes.add(this.getBooleanSerDes());
        this.javaSerDes.add(this.getShortSerDes());
        this.javaSerDes.add(this.getIntegerSerDes());
        this.javaSerDes.add(this.getLongSerDes());
        this.javaSerDes.add(this.getFloatSerDes());
        this.javaSerDes.add(this.getDoubleSerDes());
        this.javaSerDes.add(this.getByteArraySerDes());
        this.javaSerDes.add(this.getByteBufferSerDes());
        this.javaSerDes.add(this.getUUIDSerDes());
    }

    @Override
    public byte[] serialize(@Nullable Object data) {
        if (data == null) {
            return null;
        }
        return this.findSerDes(Argument.of(data.getClass())).serialize(data);
    }

    @Override
    public Object deserialize(Message message, Argument<Object> argument) {
        Argument<Object> dataType = Collection.class.isAssignableFrom(argument.getType()) ? argument.getFirstTypeVariable().orElse(argument) : argument;
        return this.findSerDes(dataType).deserialize(message, argument);
    }

    @Override
    public boolean supports(Argument<Object> argument) {
        return this.findSerDes(argument) != null;
    }

    public int getOrder() {
        return ORDER;
    }

    @Nullable
    protected NatsMessageSerDes findSerDes(Argument<?> type) {
        return this.javaSerDes.stream().filter(serDes -> serDes.supports(type)).findFirst().orElse(null);
    }

    @NonNull
    protected NatsMessageSerDes<String> getStringSerDes() {
        return new StringSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<Short> getShortSerDes() {
        return new ShortSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<Integer> getIntegerSerDes() {
        return new IntegerSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<Long> getLongSerDes() {
        return new LongSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<Float> getFloatSerDes() {
        return new FloatSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<Double> getDoubleSerDes() {
        return new DoubleSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<byte[]> getByteArraySerDes() {
        return new ByteArraySerDes();
    }

    @NonNull
    protected NatsMessageSerDes<ByteBuffer> getByteBufferSerDes() {
        return new ByteBufferSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<UUID> getUUIDSerDes() {
        return new UUIDSerDes();
    }

    @NonNull
    protected NatsMessageSerDes<Boolean> getBooleanSerDes() {
        return new BooleanSerDes();
    }

    static class BooleanSerDes
    implements NatsMessageSerDes<Boolean> {
        BooleanSerDes() {
        }

        @Override
        public Boolean deserialize(Message message, Argument<Boolean> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 1) {
                throw new SerializationException("Incorrect message body size to deserialize to a Boolean");
            }
            return data[0] != 0;
        }

        @Override
        public byte[] serialize(Boolean data) {
            if (data == null) {
                return null;
            }
            byte[] bytes = new byte[]{data != false ? (byte)1 : 0};
            return bytes;
        }

        @Override
        public boolean supports(Argument<Boolean> argument) {
            return argument.getType() == Boolean.class || argument.getType() == Boolean.TYPE;
        }
    }

    static class UUIDSerDes
    implements NatsMessageSerDes<UUID> {
        StringSerDes stringSerDes = new StringSerDes();

        UUIDSerDes() {
        }

        @Override
        public UUID deserialize(Message message, Argument<UUID> argument) {
            Object uuid = this.stringSerDes.deserialize(message, Argument.of(String.class));
            if (uuid == null) {
                return null;
            }
            return UUID.fromString((String)uuid);
        }

        @Override
        public byte[] serialize(UUID data) {
            if (data == null) {
                return null;
            }
            return this.stringSerDes.serialize(data.toString());
        }

        @Override
        public boolean supports(Argument<UUID> argument) {
            return argument.getType() == UUID.class;
        }
    }

    static class ByteBufferSerDes
    implements NatsMessageSerDes<ByteBuffer> {
        ByteBufferSerDes() {
        }

        @Override
        public ByteBuffer deserialize(Message message, Argument<ByteBuffer> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            return ByteBuffer.wrap(data);
        }

        @Override
        public byte[] serialize(ByteBuffer data) {
            if (data == null) {
                return null;
            }
            data.rewind();
            if (data.hasArray()) {
                byte[] arr = data.array();
                if (data.arrayOffset() == 0 && arr.length == data.remaining()) {
                    return arr;
                }
            }
            byte[] ret = new byte[data.remaining()];
            data.get(ret, 0, ret.length);
            data.rewind();
            return ret;
        }

        @Override
        public boolean supports(Argument<ByteBuffer> argument) {
            return argument.getType() == ByteBuffer.class;
        }
    }

    static class ByteArraySerDes
    implements NatsMessageSerDes<byte[]> {
        ByteArraySerDes() {
        }

        @Override
        public byte[] deserialize(Message message, Argument<byte[]> argument) {
            return message.getData();
        }

        @Override
        public byte[] serialize(byte[] data) {
            return data;
        }

        @Override
        public boolean supports(Argument<byte[]> argument) {
            return argument.getType() == byte[].class;
        }
    }

    static class DoubleSerDes
    implements NatsMessageSerDes<Double> {
        DoubleSerDes() {
        }

        @Override
        public Double deserialize(Message message, Argument<Double> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 8) {
                throw new SerializationException("Incorrect message body size to deserialize to a Double");
            }
            long value = 0L;
            for (byte b : data) {
                value <<= 8;
                value |= (long)(b & 0xFF);
            }
            return Double.longBitsToDouble(value);
        }

        @Override
        public byte[] serialize(Double data) {
            if (data == null) {
                return null;
            }
            long bits = Double.doubleToLongBits(data);
            return new byte[]{(byte)(bits >>> 56), (byte)(bits >>> 48), (byte)(bits >>> 40), (byte)(bits >>> 32), (byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
        }

        @Override
        public boolean supports(Argument<Double> argument) {
            return argument.getType() == Double.class || argument.getType() == Double.TYPE;
        }
    }

    static class FloatSerDes
    implements NatsMessageSerDes<Float> {
        FloatSerDes() {
        }

        @Override
        public Float deserialize(Message message, Argument<Float> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 4) {
                throw new SerializationException("Incorrect message body size to deserialize to a Float");
            }
            int value = 0;
            for (byte b : data) {
                value <<= 8;
                value |= b & 0xFF;
            }
            return Float.valueOf(Float.intBitsToFloat(value));
        }

        @Override
        public byte[] serialize(Float data) {
            if (data == null) {
                return null;
            }
            long bits = Float.floatToRawIntBits(data.floatValue());
            return new byte[]{(byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
        }

        @Override
        public boolean supports(Argument<Float> argument) {
            return argument.getType() == Float.class || argument.getType() == Float.TYPE;
        }
    }

    static class LongSerDes
    implements NatsMessageSerDes<Long> {
        LongSerDes() {
        }

        @Override
        public Long deserialize(Message message, Argument<Long> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 8) {
                throw new SerializationException("Incorrect message body size to deserialize to a Long");
            }
            long value = 0L;
            for (byte b : data) {
                value <<= 8;
                value |= (long)(b & 0xFF);
            }
            return value;
        }

        @Override
        public byte[] serialize(Long data) {
            if (data == null) {
                return null;
            }
            return new byte[]{(byte)(data >>> 56), (byte)(data >>> 48), (byte)(data >>> 40), (byte)(data >>> 32), (byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), data.byteValue()};
        }

        @Override
        public boolean supports(Argument<Long> argument) {
            return argument.getType() == Long.class || argument.getType() == Long.TYPE;
        }
    }

    static class IntegerSerDes
    implements NatsMessageSerDes<Integer> {
        IntegerSerDes() {
        }

        @Override
        public Integer deserialize(Message message, Argument<Integer> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 4) {
                throw new SerializationException("Incorrect message body size to deserialize to an Integer");
            }
            int value = 0;
            for (byte b : data) {
                value <<= 8;
                value |= b & 0xFF;
            }
            return value;
        }

        @Override
        public byte[] serialize(Integer data) {
            if (data == null) {
                return null;
            }
            return new byte[]{(byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), data.byteValue()};
        }

        @Override
        public boolean supports(Argument<Integer> argument) {
            return argument.getType() == Integer.class || argument.getType() == Integer.TYPE;
        }
    }

    static class ShortSerDes
    implements NatsMessageSerDes<Short> {
        ShortSerDes() {
        }

        @Override
        public Short deserialize(Message message, Argument<Short> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 2) {
                throw new SerializationException("Incorrect message body size to deserialize to a Short");
            }
            short value = 0;
            for (byte b : data) {
                value = (short)(value << 8);
                value = (short)(value | b & 0xFF);
            }
            return value;
        }

        @Override
        public byte[] serialize(Short data) {
            if (data == null) {
                return null;
            }
            return new byte[]{(byte)(data >>> 8), data.byteValue()};
        }

        @Override
        public boolean supports(Argument<Short> argument) {
            return argument.getType() == Short.class || argument.getType() == Short.TYPE;
        }
    }

    static class StringSerDes
    implements NatsMessageSerDes<String> {
        private static final Charset ENCODING = Charset.forName("UTF8");

        StringSerDes() {
        }

        @Override
        public String deserialize(Message message, Argument<String> argument) {
            byte[] data = message.getData();
            if (data == null || data.length == 0) {
                return null;
            }
            return new String(data, ENCODING);
        }

        @Override
        public byte[] serialize(String data) {
            if (data == null) {
                return null;
            }
            return data.getBytes(ENCODING);
        }

        @Override
        public boolean supports(Argument<String> argument) {
            return argument.getType() == String.class;
        }
    }
}

