/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.messaging.annotation.MessageHeader;
import io.micronaut.nats.bind.NatsAnnotatedArgumentBinder;
import io.micronaut.nats.bind.NatsHeaderConvertibleValues;
import io.nats.client.Message;
import io.nats.client.impl.Headers;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class NatsHeaderBinder
implements NatsAnnotatedArgumentBinder<MessageHeader> {
    private final ConversionService conversionService;

    public NatsHeaderBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Class<MessageHeader> getAnnotationType() {
        return MessageHeader.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, Message messageState) {
        String parameterName = context.getAnnotationMetadata().stringValue(MessageHeader.class).orElse(context.getArgument().getName());
        Headers rawHeaders = messageState.getHeaders();
        NatsHeaderConvertibleValues headers = new NatsHeaderConvertibleValues(rawHeaders, this.conversionService);
        Optional<Object> header = headers.get(parameterName, context);
        return () -> header;
    }
}

