/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.bind;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.nats.client.impl.Headers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class NatsHeaderConvertibleValues
implements ConvertibleValues<Object> {
    private final Headers headers;
    private final ConversionService conversionService;
    private final List<ConversionError> conversionErrors = new ArrayList<ConversionError>();

    public NatsHeaderConvertibleValues(Headers headers, ConversionService conversionService) {
        this.headers = headers == null ? new Headers() : headers;
        this.conversionService = conversionService;
    }

    public Set<String> names() {
        return this.headers.keySet();
    }

    public Collection<Object> values() {
        return this.headers.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        List value = this.headers.get(name.toString());
        if (value != null) {
            Optional converted = this.conversionService.convert((Object)value, conversionContext);
            conversionContext.getLastError().ifPresent(this.conversionErrors::add);
            return converted;
        }
        return Optional.empty();
    }

    public List<ConversionError> getConversionErrors() {
        return this.conversionErrors;
    }
}

