/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.connect;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.nats.connect.NatsConnectionFactoryConfig;
import io.nats.client.Connection;
import io.nats.client.Nats;
import io.nats.client.Options;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;

@Factory
public class NatsConnectionFactory {
    @Bean(preDestroy="close")
    @Singleton
    @EachBean(value=NatsConnectionFactoryConfig.class)
    Connection connection(NatsConnectionFactoryConfig connectionFactory, @Named(value="consumer") ExecutorService executorService) {
        try {
            return Nats.connect((Options)connectionFactory.toOptionsBuilder().executor(executorService).build());
        }
        catch (IOException | InterruptedException | GeneralSecurityException e) {
            throw new BeanInstantiationException("Error creating connection to nats", (Throwable)e);
        }
    }
}

