/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.connect;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.nats.client.JetStreamOptions;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.ObjectStoreConfiguration;
import io.nats.client.api.StreamConfiguration;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

@Requires(property="nats")
@EachProperty(value="nats", primary="default")
public class NatsConnectionFactoryConfig {
    public static final String PREFIX = "nats";
    private final String name;
    private List<String> addresses = Collections.singletonList("nats://localhost:4222");
    private int maxReconnect = 60;
    private Duration reconnectWait = Options.DEFAULT_RECONNECT_WAIT;
    private Duration connectionTimeout = Options.DEFAULT_CONNECTION_TIMEOUT;
    private Duration pingInterval = Options.DEFAULT_PING_INTERVAL;
    private long reconnectBufferSize = 0x800000L;
    private String inboxPrefix = "_INBOX.";
    private boolean noEcho;
    private boolean utf8Support;
    private String username;
    private String password;
    private String token;
    private String credentials;
    private TLS tls;
    @Nullable
    private JetStreamConfiguration jetstream;

    public NatsConnectionFactoryConfig(@Parameter String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<String>> getAddresses() {
        return Optional.ofNullable(this.addresses);
    }

    public void setAddresses(@Nullable List<String> addresses) {
        this.addresses = addresses;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public void setMaxReconnect(int maxReconnect) {
        this.maxReconnect = maxReconnect;
    }

    public Duration getReconnectWait() {
        return this.reconnectWait;
    }

    public void setReconnectWait(Duration reconnectWait) {
        this.reconnectWait = reconnectWait;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(Duration pingInterval) {
        this.pingInterval = pingInterval;
    }

    public long getReconnectBufferSize() {
        return this.reconnectBufferSize;
    }

    public void setReconnectBufferSize(long reconnectBufferSize) {
        this.reconnectBufferSize = reconnectBufferSize;
    }

    public String getInboxPrefix() {
        return this.inboxPrefix;
    }

    public void setInboxPrefix(String inboxPrefix) {
        this.inboxPrefix = inboxPrefix;
    }

    public boolean isNoEcho() {
        return this.noEcho;
    }

    public void setNoEcho(boolean noEcho) {
        this.noEcho = noEcho;
    }

    public boolean isUtf8Support() {
        return this.utf8Support;
    }

    public void setUtf8Support(boolean utf8Support) {
        this.utf8Support = utf8Support;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setTls(@Nullable TLS tls) {
        this.tls = tls;
    }

    public Options.Builder toOptionsBuilder() throws IOException, GeneralSecurityException {
        Options.Builder builder = new Options.Builder();
        builder = builder.servers(this.addresses.toArray(new String[0]));
        builder = builder.maxReconnects(this.maxReconnect);
        builder = builder.reconnectWait(this.reconnectWait);
        builder = builder.connectionTimeout(this.connectionTimeout);
        builder = builder.connectionName(this.name);
        builder = builder.pingInterval(this.pingInterval);
        builder = builder.reconnectBufferSize(this.reconnectBufferSize);
        builder = builder.inboxPrefix(this.inboxPrefix);
        if (this.noEcho) {
            builder = builder.noEcho();
        }
        if (this.utf8Support) {
            builder = builder.supportUTF8Subjects();
        }
        if (this.credentials != null && !this.credentials.isEmpty()) {
            builder = builder.authHandler(Nats.credentials((String)this.credentials));
        } else if (this.token != null && !this.token.isEmpty()) {
            builder = builder.token(this.token.toCharArray());
        } else if (this.username != null && !this.username.isEmpty()) {
            builder = builder.userInfo(this.username, this.password);
        }
        if (this.tls != null) {
            builder.sslContext(this.tls.createTlsContext());
        }
        return builder;
    }

    @Nullable
    public JetStreamConfiguration getJetstream() {
        return this.jetstream;
    }

    public void setJetstream(@Nullable JetStreamConfiguration jetstream) {
        this.jetstream = jetstream;
    }

    @ConfigurationProperties(value="tls")
    public static class TLS {
        private String trustStorePath;
        private String trustStorePassword;
        private String trustStoreType;
        private String certificatePath;

        public String getTrustStorePath() {
            return this.trustStorePath;
        }

        public void setTrustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public void setTrustStoreType(@Nullable String trustStoreType) {
            this.trustStoreType = trustStoreType;
        }

        public String getCertificatePath() {
            return this.certificatePath;
        }

        public void setCertificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
        }

        private SSLContext createTlsContext() throws IOException, GeneralSecurityException {
            BufferedInputStream in;
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory factory = TrustManagerFactory.getInstance(Optional.ofNullable(this.trustStoreType).orElse("SunX509"));
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            if (this.trustStorePath != null && !this.trustStorePath.isEmpty()) {
                in = new BufferedInputStream(Files.newInputStream(Paths.get(this.trustStorePath, new String[0]), new OpenOption[0]));
                try {
                    ks.load(in, Optional.ofNullable(this.trustStorePassword).map(String::toCharArray).orElse(new char[0]));
                }
                finally {
                    in.close();
                }
            } else {
                ks.load(null);
            }
            if (this.certificatePath != null && !this.certificatePath.isEmpty()) {
                in = new BufferedInputStream(Files.newInputStream(Paths.get(this.certificatePath, new String[0]), new OpenOption[0]));
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
                    ks.setCertificateEntry(NatsConnectionFactoryConfig.PREFIX, cert);
                }
                finally {
                    in.close();
                }
            }
            factory.init(ks);
            ctx.init(null, factory.getTrustManagers(), new SecureRandom());
            return ctx;
        }
    }

    @ConfigurationProperties(value="jetstream")
    public static class JetStreamConfiguration {
        @ConfigurationBuilder(prefixes={""})
        private JetStreamOptions.Builder builder = JetStreamOptions.builder((JetStreamOptions)JetStreamOptions.defaultOptions());
        private List<StreamConfiguration> streams = new ArrayList<StreamConfiguration>();
        private List<KeyValueConfiguration> keyvalue = new ArrayList<KeyValueConfiguration>();
        private List<ObjectStoreConfiguration> objectstore = new ArrayList<ObjectStoreConfiguration>();

        public JetStreamOptions.Builder getBuilder() {
            return this.builder;
        }

        public JetStreamOptions toJetStreamOptions() {
            return this.builder.build();
        }

        public List<StreamConfiguration> getStreams() {
            return this.streams;
        }

        public void setStreams(List<StreamConfiguration> streams) {
            this.streams = streams;
        }

        public List<KeyValueConfiguration> getKeyvalue() {
            return this.keyvalue;
        }

        public void setKeyvalue(List<KeyValueConfiguration> keyvalue) {
            this.keyvalue = keyvalue;
        }

        public List<ObjectStoreConfiguration> getObjectstore() {
            return this.objectstore;
        }

        public void setObjectstore(List<ObjectStoreConfiguration> objectstore) {
            this.objectstore = objectstore;
        }

        @EachProperty(value="objectstore")
        public static class ObjectStoreConfiguration {
            private final String name;
            @ConfigurationBuilder(prefixes={""}, excludes={"name", "build"})
            private ObjectStoreConfiguration.Builder builder = io.nats.client.api.ObjectStoreConfiguration.builder();
            private boolean create = true;

            public ObjectStoreConfiguration(@Parameter String name) {
                this.name = name;
            }

            public ObjectStoreConfiguration.Builder getBuilder() {
                return this.builder;
            }

            public io.nats.client.api.ObjectStoreConfiguration toObjectStoreConfiguration() {
                return this.builder.name(this.name).build();
            }

            public boolean isCreate() {
                return this.create;
            }

            public void setCreate(boolean create) {
                this.create = create;
            }
        }

        @EachProperty(value="keyvalue")
        public static class KeyValueConfiguration {
            private final String name;
            @ConfigurationBuilder(prefixes={""}, excludes={"addSources", "addSource", "name", "sources", "build"})
            private KeyValueConfiguration.Builder builder = io.nats.client.api.KeyValueConfiguration.builder();
            private boolean createOrUpdate = true;

            public KeyValueConfiguration(@Parameter String name) {
                this.name = name;
            }

            public KeyValueConfiguration.Builder getBuilder() {
                return this.builder;
            }

            public io.nats.client.api.KeyValueConfiguration toKeyValueConfiguration() {
                return this.builder.name(this.name).build();
            }

            public boolean isCreateOrUpdate() {
                return this.createOrUpdate;
            }

            public void setCreateOrUpdate(boolean createOrUpdate) {
                this.createOrUpdate = createOrUpdate;
            }
        }

        @EachProperty(value="streams")
        public static class StreamConfiguration {
            @ConfigurationBuilder(prefixes={""}, excludes={"addSubjects", "addSources", "addSource", "name", "subjects", "build"})
            private StreamConfiguration.Builder builder = io.nats.client.api.StreamConfiguration.builder();
            private final String name;
            private List<String> subjects;
            private boolean createOrUpdate = true;

            public StreamConfiguration(@Parameter String name) {
                this.name = name;
            }

            public StreamConfiguration.Builder getBuilder() {
                return this.builder;
            }

            public io.nats.client.api.StreamConfiguration toStreamConfiguration() {
                return this.builder.name(this.name).subjects(this.subjects).build();
            }

            public List<String> getSubjects() {
                return this.subjects;
            }

            public void setSubjects(List<String> subjects) {
                this.subjects = subjects;
            }

            public boolean isCreateOrUpdate() {
                return this.createOrUpdate;
            }

            public void setCreateOrUpdate(boolean createOrUpdate) {
                this.createOrUpdate = createOrUpdate;
            }
        }
    }
}

