/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.exception;

import io.micronaut.context.annotation.Primary;
import io.micronaut.nats.exception.NatsListenerException;
import io.micronaut.nats.exception.NatsListenerExceptionHandler;
import io.nats.client.Message;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
public class DefaultNatsListenerExceptionHandler
implements NatsListenerExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNatsListenerExceptionHandler.class);

    public void handle(NatsListenerException exception) {
        if (LOG.isErrorEnabled()) {
            Optional<Message> messageState = exception.getMessageState();
            if (messageState.isPresent()) {
                LOG.error("Error processing a message for nats listener [{}]", exception.getListener(), (Object)exception);
            } else {
                LOG.error("Nats listener [{}] produced an error", exception.getListener(), (Object)exception);
            }
        }
    }
}

