/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.intercept;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.messaging.annotation.MessageBody;
import io.micronaut.messaging.annotation.MessageHeader;
import io.micronaut.nats.annotation.NatsConnection;
import io.micronaut.nats.annotation.Subject;
import io.micronaut.nats.exception.NatsClientException;
import io.micronaut.nats.intercept.StaticPublisherState;
import io.micronaut.nats.reactive.ReactivePublisher;
import io.micronaut.nats.serdes.NatsMessageSerDes;
import io.micronaut.nats.serdes.NatsMessageSerDesRegistry;
import io.nats.client.Message;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsMessage;
import jakarta.inject.Named;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public abstract class AbstractIntroductionAdvice {
    protected final BeanContext beanContext;
    protected final Scheduler scheduler;
    protected final NatsMessageSerDesRegistry serDesRegistry;
    protected final ConversionService conversionService;

    protected AbstractIntroductionAdvice(BeanContext beanContext, @Named(value="consumer") ExecutorService executorService, ConversionService conversionService, NatsMessageSerDesRegistry serDesRegistry) {
        this.beanContext = beanContext;
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)executorService);
        this.conversionService = conversionService;
        this.serDesRegistry = serDesRegistry;
    }

    protected static Object handleResult(InterceptedMethod interceptedMethod, Mono<?> reactive) {
        switch (interceptedMethod.resultType()) {
            case PUBLISHER: {
                return interceptedMethod.handleResult(reactive);
            }
            case COMPLETION_STAGE: {
                final CompletableFuture future = new CompletableFuture();
                reactive.subscribe((Subscriber)new Subscriber<Object>(){
                    Object value = null;

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Object o) {
                        this.value = o;
                    }

                    public void onError(Throwable t) {
                        future.completeExceptionally(t);
                    }

                    public void onComplete() {
                        future.complete(this.value);
                    }
                });
                return interceptedMethod.handleResult(future);
            }
            case SYNCHRONOUS: {
                return interceptedMethod.handleResult(reactive.block());
            }
        }
        return interceptedMethod.unsupported();
    }

    protected Message buildNatsMessage(MethodInvocationContext<Object, Object> context, Headers headers, Argument<?> bodyArgument, NatsMessageSerDes<Object> serDes, Optional<String> subjectOptional) {
        NatsMessage.Builder builder = NatsMessage.builder();
        Argument[] arguments = context.getArguments();
        Map parameterValues = context.getParameterValueMap();
        for (Argument argument : arguments) {
            boolean headersObject;
            AnnotationValue headerAnn = argument.getAnnotation(MessageHeader.class);
            boolean bl = headersObject = argument.getType() == Headers.class;
            if (headerAnn != null) {
                Map.Entry<String, List<String>> entry = this.getNameAndValue(argument, headerAnn, parameterValues);
                String name = entry.getKey();
                List<String> value = entry.getValue();
                if (value.isEmpty() && headers.containsKey(name)) {
                    headers.remove(new String[]{name});
                    continue;
                }
                headers.put(name, value);
                continue;
            }
            if (!headersObject) continue;
            Headers dynamicHeaders = (Headers)parameterValues.get(argument.getName());
            dynamicHeaders.forEach((arg_0, arg_1) -> ((Headers)headers).put(arg_0, arg_1));
        }
        if (!headers.isEmpty()) {
            builder.headers(headers);
        }
        Object body = parameterValues.get(bodyArgument.getName());
        byte[] converted = serDes.serialize(body);
        builder = builder.data(converted);
        String subject = subjectOptional.orElse(this.findSubjectKey(context).orElse(null));
        builder = builder.subject(subject);
        if (subject == null) {
            throw new IllegalStateException("No @Subject annotation present on method: " + context.getExecutableMethod());
        }
        return builder.build();
    }

    protected StaticPublisherState buildPublisherState(ExecutableMethod<?, ?> method) {
        ReactivePublisher reactivePublisher;
        Optional subject = method.findAnnotation(Subject.class).flatMap(AnnotationValue::stringValue);
        String connection = method.stringValue(NatsConnection.class, "connection").orElse("default");
        Argument<?> bodyArgument = this.findBodyArgument(method).orElseThrow(() -> new NatsClientException("No valid message body argument found for method: " + method));
        Headers methodHeaders = new Headers();
        List headerAnnotations = method.getAnnotationValuesByType(MessageHeader.class);
        Collections.reverse(headerAnnotations);
        headerAnnotations.forEach(header -> {
            String name = header.stringValue("name").orElse(null);
            String value = header.stringValue().orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value)) {
                methodHeaders.put(name, new String[]{value});
            }
        });
        NatsMessageSerDes<?> serDes = this.serDesRegistry.findSerdes(bodyArgument).orElseThrow(() -> new NatsClientException(String.format("Could not find a serializer for the body argument of type [%s]", bodyArgument.getType().getName())));
        try {
            reactivePublisher = (ReactivePublisher)this.beanContext.getBean(ReactivePublisher.class, Qualifiers.byName((String)connection));
        }
        catch (Exception e) {
            throw new NatsClientException(String.format("Failed to retrieve a publisher named [%s] to publish messages", connection), e);
        }
        return new StaticPublisherState(subject.orElse(null), bodyArgument, methodHeaders, method.getReturnType(), connection, serDes, reactivePublisher);
    }

    private Optional<String> findSubjectKey(MethodInvocationContext<Object, Object> method) {
        Map argumentValues = method.getParameterValueMap();
        return Arrays.stream(method.getArguments()).filter(arg -> arg.getAnnotationMetadata().hasAnnotation(Subject.class)).map(Argument::getName).map(argumentValues::get).filter(Objects::nonNull).map(Object::toString).findFirst();
    }

    private Map.Entry<String, List<String>> getNameAndValue(Argument<?> argument, AnnotationValue<?> annotationValue, Map<String, Object> parameterValues) {
        String argumentName = argument.getName();
        String name = annotationValue.stringValue("name").orElse(annotationValue.stringValue().orElse(argumentName));
        Optional value = this.conversionService.convert(parameterValues.get(argumentName), Argument.of(List.class, (Class[])new Class[]{String.class}));
        return new AbstractMap.SimpleEntry<String, List<String>>(name, value.orElse(Collections.emptyList()));
    }

    private Optional<Argument<?>> findBodyArgument(ExecutableMethod<?, ?> method) {
        return Optional.ofNullable(Arrays.stream(method.getArguments()).filter(arg -> arg.getAnnotationMetadata().hasAnnotation(MessageBody.class)).findFirst().orElseGet(() -> Arrays.stream(method.getArguments()).filter(arg -> !arg.getAnnotationMetadata().hasStereotype(Subject.class)).findFirst().orElse(null)));
    }
}

