/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.nats.reactive.ReactivePublisher;
import io.micronaut.nats.serdes.NatsMessageSerDes;
import io.nats.client.impl.Headers;
import java.util.Optional;

@Internal
public class StaticPublisherState {
    private final String subject;
    private final Argument<?> bodyArgument;
    private final Headers headers;
    private final String connection;
    private final NatsMessageSerDes<?> serDes;
    private final Argument<?> dataType;
    private final ReactivePublisher reactivePublisher;

    protected StaticPublisherState(String subject, Argument<?> bodyArgument, Headers methodHeaders, ReturnType<?> returnType, String connection, NatsMessageSerDes<?> serDes, ReactivePublisher reactivePublisher) {
        this.subject = subject;
        this.bodyArgument = bodyArgument;
        this.headers = methodHeaders;
        this.serDes = serDes;
        this.connection = connection;
        this.reactivePublisher = reactivePublisher;
        Class javaReturnType = returnType.getType();
        boolean reactive = Publishers.isConvertibleToPublisher((Class)javaReturnType);
        this.dataType = reactive ? returnType.getFirstTypeVariable().orElse(Argument.VOID) : returnType.asArgument();
    }

    protected StaticPublisherState(StaticPublisherState other) {
        this.subject = other.subject;
        this.bodyArgument = other.bodyArgument;
        this.headers = other.headers;
        this.serDes = other.serDes;
        this.reactivePublisher = other.reactivePublisher;
        this.dataType = other.dataType;
        this.connection = other.connection;
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public Argument getBodyArgument() {
        return this.bodyArgument;
    }

    public Headers getHeaders() {
        return new Headers(this.headers);
    }

    public Argument getDataType() {
        return this.dataType;
    }

    public NatsMessageSerDes<Object> getSerDes() {
        return this.serDes;
    }

    public ReactivePublisher getReactivePublisher() {
        return this.reactivePublisher;
    }

    public String getConnection() {
        return this.connection;
    }
}

