/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.jetstream;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.nats.connect.NatsConnectionFactoryConfig;
import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamInfo;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;

@Factory
public class JetStreamFactory {
    private final BeanContext beanContext;

    @Inject
    public JetStreamFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Singleton
    @EachBean(value=NatsConnectionFactoryConfig.class)
    JetStreamManagement jetStreamManagement(NatsConnectionFactoryConfig config) throws IOException {
        if (config.getJetstream() != null) {
            return this.getConnectionByName(config.getName()).jetStreamManagement(config.getJetstream().toJetStreamOptions());
        }
        return null;
    }

    @Singleton
    @EachBean(value=NatsConnectionFactoryConfig.class)
    JetStream jetStream(NatsConnectionFactoryConfig config) throws IOException, JetStreamApiException {
        if (config.getJetstream() != null) {
            Connection connection = this.getConnectionByName(config.getName());
            this.createOrUpdateStreams(config);
            return connection.jetStream(config.getJetstream().toJetStreamOptions());
        }
        return null;
    }

    private void createOrUpdateStreams(NatsConnectionFactoryConfig config) throws IOException, JetStreamApiException {
        JetStreamManagement jetStreamManagement = this.getConnectionByName(config.getName()).jetStreamManagement(config.getJetstream().toJetStreamOptions());
        for (NatsConnectionFactoryConfig.JetStreamConfiguration.StreamConfiguration stream : config.getJetstream().getStreams()) {
            if (!stream.isCreateOrUpdate()) continue;
            this.createOrUpdateStream(stream, jetStreamManagement);
        }
    }

    private void createOrUpdateStream(NatsConnectionFactoryConfig.JetStreamConfiguration.StreamConfiguration stream, JetStreamManagement jetStreamManagement) throws IOException, JetStreamApiException {
        StreamConfiguration streamConfiguration = stream.toStreamConfiguration();
        if (jetStreamManagement.getStreamNames().contains(streamConfiguration.getName())) {
            StreamInfo streamInfo = jetStreamManagement.getStreamInfo(streamConfiguration.getName());
            for (String sub : streamInfo.getConfiguration().getSubjects()) {
                if (streamConfiguration.getSubjects().contains(sub)) continue;
                streamConfiguration.getSubjects().add(sub);
            }
            if (!streamInfo.getConfiguration().equals(streamConfiguration)) {
                jetStreamManagement.updateStream(streamConfiguration);
            }
        } else {
            jetStreamManagement.addStream(streamConfiguration);
        }
    }

    private Connection getConnectionByName(String connectionName) {
        return (Connection)this.beanContext.findBean(Connection.class, Qualifiers.byName((String)connectionName)).orElseThrow(() -> new IllegalStateException("No nats connection found for " + connectionName));
    }
}

