/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.jetstream;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.nats.annotation.NatsConnection;
import io.micronaut.nats.connect.NatsConnectionFactoryConfig;
import io.micronaut.nats.jetstream.annotation.KeyValueStore;
import io.nats.client.Connection;
import io.nats.client.JetStreamApiException;
import io.nats.client.KeyValue;
import io.nats.client.KeyValueManagement;
import io.nats.client.KeyValueOptions;
import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.KeyValueStatus;
import jakarta.inject.Singleton;
import java.io.IOException;

@Factory
public class KeyValueFactory {
    private final BeanContext beanContext;

    public KeyValueFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    private static KeyValueOptions buildKeyValueOptions(NatsConnectionFactoryConfig config) {
        return ((KeyValueOptions.Builder)KeyValueOptions.builder().jetStreamOptions(config.getJetstream().toJetStreamOptions())).build();
    }

    @EachBean(value=NatsConnectionFactoryConfig.class)
    KeyValueManagement keyValueManagement(NatsConnectionFactoryConfig config) throws IOException, JetStreamApiException {
        if (config.getJetstream() != null) {
            KeyValueManagement keyValueManagement = this.getConnectionByName(config.getName()).keyValueManagement(KeyValueFactory.buildKeyValueOptions(config));
            this.createOrUpdateKeyValueStores(config, keyValueManagement);
            return keyValueManagement;
        }
        return null;
    }

    private void createOrUpdateKeyValueStores(NatsConnectionFactoryConfig config, KeyValueManagement keyValueManagement) throws IOException, JetStreamApiException {
        for (NatsConnectionFactoryConfig.JetStreamConfiguration.KeyValueConfiguration keyValue : config.getJetstream().getKeyvalue()) {
            if (!keyValue.isCreateOrUpdate()) continue;
            this.createOrUpdateKeyValueStore(keyValueManagement, keyValue);
        }
    }

    private void createOrUpdateKeyValueStore(KeyValueManagement keyValueManagement, NatsConnectionFactoryConfig.JetStreamConfiguration.KeyValueConfiguration keyValue) throws IOException, JetStreamApiException {
        KeyValueConfiguration keyValueConfiguration = keyValue.toKeyValueConfiguration();
        if (keyValueManagement.getBucketNames().contains(keyValueConfiguration.getBucketName())) {
            KeyValueStatus status = keyValueManagement.getStatus(keyValueConfiguration.getBucketName());
            if (!status.getConfiguration().equals(keyValueConfiguration)) {
                keyValueManagement.update(keyValueConfiguration);
            }
        } else {
            keyValueManagement.create(keyValueConfiguration);
        }
    }

    @Singleton
    KeyValue keyvalue(@Nullable InjectionPoint<?> injectionPoint) throws IOException {
        if (injectionPoint == null) {
            return null;
        }
        AnnotationMetadata annotationMetadata = injectionPoint.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(KeyValueStore.class)) {
            String bucketName = (String)annotationMetadata.getAnnotation(KeyValueStore.class).getRequiredValue(String.class);
            String connectionName = annotationMetadata.stringValue(NatsConnection.class, "connection").orElse("default");
            NatsConnectionFactoryConfig natsConnectionFactoryConfig = (NatsConnectionFactoryConfig)this.beanContext.getBean(NatsConnectionFactoryConfig.class, Qualifiers.byName((String)connectionName));
            this.beanContext.getBean(KeyValueManagement.class, Qualifiers.byName((String)connectionName));
            KeyValueOptions keyValueOptions = KeyValueFactory.buildKeyValueOptions(natsConnectionFactoryConfig);
            return this.getConnectionByName(connectionName).keyValue(bucketName, keyValueOptions);
        }
        return null;
    }

    private Connection getConnectionByName(String connectionName) {
        return (Connection)this.beanContext.findBean(Connection.class, Qualifiers.byName((String)connectionName)).orElseThrow(() -> new IllegalStateException("No nats connection found for " + connectionName));
    }
}

