/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.jetstream;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.nats.annotation.NatsConnection;
import io.micronaut.nats.connect.NatsConnectionFactoryConfig;
import io.micronaut.nats.jetstream.annotation.ObjectStore;
import io.nats.client.Connection;
import io.nats.client.JetStreamApiException;
import io.nats.client.ObjectStoreManagement;
import io.nats.client.ObjectStoreOptions;
import io.nats.client.api.ObjectStoreConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;

@Factory
public class ObjectStoreFactory {
    private final BeanContext beanContext;

    public ObjectStoreFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    private static ObjectStoreOptions buildObjectStoreOptions(NatsConnectionFactoryConfig config) {
        return ((ObjectStoreOptions.Builder)ObjectStoreOptions.builder().jetStreamOptions(config.getJetstream().toJetStreamOptions())).build();
    }

    @EachBean(value=NatsConnectionFactoryConfig.class)
    ObjectStoreManagement objectStoreManagement(NatsConnectionFactoryConfig config) throws IOException, JetStreamApiException {
        if (config.getJetstream() != null) {
            ObjectStoreManagement objectStoreManagement = this.getConnectionByName(config.getName()).objectStoreManagement(ObjectStoreFactory.buildObjectStoreOptions(config));
            for (NatsConnectionFactoryConfig.JetStreamConfiguration.ObjectStoreConfiguration objectStore : config.getJetstream().getObjectstore()) {
                if (!objectStore.isCreate()) continue;
                ObjectStoreConfiguration objectStoreConfiguration = objectStore.toObjectStoreConfiguration();
                if (objectStoreManagement.getBucketNames().contains(objectStoreConfiguration.getBucketName())) continue;
                objectStoreManagement.create(objectStoreConfiguration);
            }
            return objectStoreManagement;
        }
        return null;
    }

    @Singleton
    io.nats.client.ObjectStore objectStore(@Nullable InjectionPoint<?> injectionPoint) throws IOException {
        if (injectionPoint == null) {
            return null;
        }
        AnnotationMetadata annotationMetadata = injectionPoint.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(ObjectStore.class)) {
            String bucketName = (String)annotationMetadata.getAnnotation(ObjectStore.class).getRequiredValue(String.class);
            String connectionName = annotationMetadata.stringValue(NatsConnection.class, "connection").orElse("default");
            NatsConnectionFactoryConfig natsConnectionFactoryConfig = (NatsConnectionFactoryConfig)this.beanContext.getBean(NatsConnectionFactoryConfig.class, Qualifiers.byName((String)connectionName));
            this.beanContext.getBean(ObjectStoreManagement.class, Qualifiers.byName((String)connectionName));
            ObjectStoreOptions objectStoreOptions = ObjectStoreFactory.buildObjectStoreOptions(natsConnectionFactoryConfig);
            return this.getConnectionByName(connectionName).objectStore(bucketName, objectStoreOptions);
        }
        return null;
    }

    private Connection getConnectionByName(String connectionName) {
        return (Connection)this.beanContext.findBean(Connection.class, Qualifiers.byName((String)connectionName)).orElseThrow(() -> new IllegalStateException("No nats connection found for " + connectionName));
    }
}

