/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.jetstream;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.PullSubscribeOptions;
import jakarta.inject.Singleton;
import java.io.IOException;

@Singleton
public class PullConsumerRegistry {
    private final BeanContext beanContext;

    public PullConsumerRegistry(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public JetStreamSubscription newPullConsumer(@NonNull String subject, @NonNull PullSubscribeOptions pullSubscribeOptions) throws JetStreamApiException, IOException {
        JetStream jetStream = (JetStream)this.beanContext.getBean(JetStream.class, Qualifiers.byName((String)"default"));
        return jetStream.subscribe(subject, pullSubscribeOptions);
    }

    public JetStreamSubscription newPullConsumer(@NonNull String connectionName, @NonNull String subject, @NonNull PullSubscribeOptions pullSubscribeOptions) throws JetStreamApiException, IOException {
        JetStream jetStream = (JetStream)this.beanContext.getBean(JetStream.class, Qualifiers.byName((String)connectionName));
        return jetStream.subscribe(subject, pullSubscribeOptions);
    }
}

