/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.jetstream.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.messaging.Acknowledgement;
import io.micronaut.messaging.exceptions.MessageAcknowledgementException;
import io.micronaut.nats.bind.NatsTypeArgumentBinder;
import io.micronaut.nats.jetstream.bind.NatsAcknowledgement;
import io.nats.client.Message;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Optional;

@Singleton
@Internal
public class AcknowledgementBinder<T extends Acknowledgement>
implements NatsTypeArgumentBinder<T> {
    public Argument<T> argumentType() {
        return Argument.of(Acknowledgement.class);
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, final Message source) {
        NatsAcknowledgement acknowledgement = new NatsAcknowledgement(){

            public void ack() throws MessageAcknowledgementException {
                source.ack();
            }

            public void nack() throws MessageAcknowledgementException {
                source.nak();
            }

            @Override
            public void nackWithDelay(@NonNull Duration duration) {
                source.nakWithDelay(duration);
            }
        };
        return () -> Optional.of(acknowledgement);
    }
}

