/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.jetstream.exception;

import io.micronaut.context.annotation.Primary;
import io.micronaut.nats.jetstream.exception.JetStreamListenerException;
import io.micronaut.nats.jetstream.exception.JetStreamListenerExceptionHandler;
import io.nats.client.Message;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
public class DefaultJetStreamListenerExceptionHandler
implements JetStreamListenerExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJetStreamListenerExceptionHandler.class);

    public void handle(JetStreamListenerException exception) {
        if (LOG.isErrorEnabled()) {
            Optional<Message> messageState = exception.getMessageState();
            if (messageState.isPresent()) {
                LOG.error("Error processing a message for JetStream listener [{}]", exception.getListener(), (Object)exception);
            } else {
                LOG.error("JetStream listener [{}] produced an error", exception.getListener(), (Object)exception);
            }
        }
    }
}

