/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.jetstream.reactive;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.nats.jetstream.reactive.ReactivePublisher;
import io.nats.client.JetStream;
import io.nats.client.Message;
import io.nats.client.PublishOptions;
import io.nats.client.api.PublishAck;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
@EachBean(value=JetStream.class)
class ReactorReactivePublisher
implements ReactivePublisher {
    private final Mono<JetStream> jetStream;

    public ReactorReactivePublisher(@Parameter JetStream jetStream) {
        this.jetStream = Mono.just((Object)jetStream);
    }

    @Override
    public Publisher<PublishAck> publish(Message message) {
        return this.jetStream.flatMap(js -> Mono.fromFuture((CompletableFuture)js.publishAsync(message)));
    }

    @Override
    public Publisher<PublishAck> publish(Message message, PublishOptions options) {
        return this.jetStream.flatMap(js -> Mono.fromFuture((CompletableFuture)js.publishAsync(message, options)));
    }
}

