/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.reactive;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.nats.reactive.ReactivePublisher;
import io.nats.client.Connection;
import io.nats.client.Message;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
@EachBean(value=Connection.class)
public class ReactorReactivePublisher
implements ReactivePublisher {
    private final Mono<Connection> connection;

    public ReactorReactivePublisher(@Parameter Connection connection) {
        this.connection = Mono.just((Object)connection);
    }

    @Override
    public Publisher<Void> publish(Message message) {
        return this.connection.flatMap(con -> Mono.create(subscriber -> {
            con.publish(message);
            subscriber.success();
        }));
    }

    @Override
    public Publisher<Message> publishAndReply(Message message) {
        return this.connection.flatMap(con -> Mono.fromFuture((CompletableFuture)con.request(message)));
    }
}

