/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.nats.serdes;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import io.micronaut.nats.serdes.NatsMessageSerDes;
import io.nats.client.Message;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;

@Singleton
public class JsonNatsMessageSerDes
implements NatsMessageSerDes<Object> {
    public static final Integer ORDER = 200;
    private final JsonMapper jsonMapper;

    @Inject
    public JsonNatsMessageSerDes(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    @Nullable
    public Object deserialize(Message message, Argument<Object> type) {
        byte[] body = message.getData();
        if (body == null || body.length == 0) {
            return null;
        }
        try {
            return this.jsonMapper.readValue(body, type);
        }
        catch (IOException e) {
            throw new SerializationException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage());
        }
    }

    @Override
    public byte[] serialize(Object data) {
        if (data == null) {
            return null;
        }
        try {
            return this.jsonMapper.writeValueAsBytes(data);
        }
        catch (IOException e) {
            throw new SerializationException("Error encoding object [" + data + "] to JSON: " + e.getMessage());
        }
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public boolean supports(Argument<Object> argument) {
        return !ClassUtils.isJavaBasicType((Class)argument.getType());
    }
}

