/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.neo4j.bolt;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.neo4j.bolt.Neo4jBoltSettings;
import jakarta.inject.Inject;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;

@ConfigurationProperties(value="neo4j")
public class Neo4jBoltConfiguration
implements Neo4jBoltSettings {
    public static final int DEFAULT_RETRYCOUNT = 3;
    public static final int DEFAULT_RETRYDELAY_SECONDS = 1;
    @ConfigurationBuilder(prefixes={"with"}, allowZeroArgs=true)
    protected Config.ConfigBuilder config = Config.builder();
    private List<URI> uris = Collections.singletonList(URI.create("bolt://localhost:7687"));
    private AuthToken authToken;
    private String username;
    private String password;
    private int retryCount = 3;
    private Duration retryDelay = Duration.of(1L, ChronoUnit.SECONDS);
    private Neo4jEmbeddedSettings embeddedSettings = new Neo4jEmbeddedSettings();

    public Neo4jBoltConfiguration() {
        this.config.withLogging(Logging.slf4j());
    }

    public List<URI> getUris() {
        return this.uris;
    }

    public void setUris(List<URI> uris) {
        if (uris != null) {
            this.uris = uris;
        }
    }

    public void setUri(URI uri) {
        if (uri != null) {
            this.uris = Collections.singletonList(uri);
        }
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Duration retryDelay) {
        if (retryDelay != null) {
            this.retryDelay = retryDelay;
        }
    }

    public Config getConfig() {
        return this.config.build();
    }

    public Config.ConfigBuilder getConfigBuilder() {
        return this.config;
    }

    public Optional<AuthToken> getAuthToken() {
        if (this.authToken != null) {
            return Optional.of(this.authToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password)) {
            return Optional.of(AuthTokens.basic((String)this.username, (String)this.password));
        }
        return Optional.empty();
    }

    @Inject
    public void setAuthToken(@Nullable AuthToken authToken) {
        this.authToken = authToken;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Inject
    public void setTrustStrategy(@Nullable Config.TrustStrategy trustStrategy) {
        if (trustStrategy != null) {
            this.config.withTrustStrategy(trustStrategy);
        }
    }

    public Neo4jEmbeddedSettings getEmbeddedSettings() {
        return this.embeddedSettings;
    }

    @Inject
    public void setEmbeddedSettings(Neo4jEmbeddedSettings embeddedSettings) {
        this.embeddedSettings = embeddedSettings;
    }

    @ConfigurationProperties(value="embedded")
    public static class Neo4jEmbeddedSettings
    implements Toggleable {
        public static final boolean DEFAULT_ENABLED = true;
        public static final boolean DEFAULT_EPHEMERAL = false;
        public static final boolean DEFAULT_DROPDATA = false;
        private Map<String, Object> options = Collections.emptyMap();
        private String directory;
        private boolean dropData = false;
        private boolean ephemeral = false;
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Map<String, Object> getOptions() {
            return this.options;
        }

        public void setOptions(Map<String, Object> options) {
            if (options != null) {
                this.options = options;
            }
        }

        public Optional<String> getDirectory() {
            return Optional.ofNullable(this.directory);
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public boolean isDropData() {
            return this.dropData;
        }

        public void setDropData(boolean dropData) {
            this.dropData = dropData;
        }

        public boolean isEphemeral() {
            return this.ephemeral;
        }

        public void setEphemeral(boolean ephemeral) {
            this.ephemeral = ephemeral;
        }
    }
}

