/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.neo4j.bolt.embedded;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.neo4j.bolt.Neo4jBoltConfiguration;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.server.ServerStartupException;

@Singleton
@Requires(classes={ServerControls.class})
public class EmbeddedNeo4jServer
implements BeanCreatedEventListener<Neo4jBoltConfiguration>,
Closeable {
    private static final int RETRY_COUNT_MAX = 4;
    private ServerControls serverControls;

    public Neo4jBoltConfiguration onCreated(BeanCreatedEvent<Neo4jBoltConfiguration> event) {
        Neo4jBoltConfiguration configuration = (Neo4jBoltConfiguration)event.getBean();
        List<URI> uris = configuration.getUris();
        if (uris.size() == 1) {
            URI uri = uris.get(0);
            int port = uri.getPort();
            Neo4jBoltConfiguration.Neo4jEmbeddedSettings embeddedSettings = configuration.getEmbeddedSettings();
            if (port > -1 && SocketUtils.isTcpPortAvailable((int)port) && embeddedSettings.isEnabled()) {
                File dataDir;
                String location = embeddedSettings.getDirectory().orElse(null);
                Map<String, Object> options = embeddedSettings.getOptions();
                try {
                    dataDir = location != null ? new File(location) : (embeddedSettings.isEphemeral() ? File.createTempFile("neo4j-temporary-data", "-tempdir") : new File("data/neo4j"));
                }
                catch (IOException e) {
                    throw new ConfigurationException("Unable to create Neo4j temporary data directory: " + e.getMessage(), (Throwable)e);
                }
                if (embeddedSettings.isDropData() || embeddedSettings.isEphemeral()) {
                    dataDir.delete();
                }
                if (embeddedSettings.isEphemeral()) {
                    dataDir.deleteOnExit();
                }
                try {
                    this.serverControls = EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataDir, options);
                    URI boltURI = this.serverControls.boltURI();
                    configuration.setUri(boltURI);
                }
                catch (Throwable e) {
                    throw new ConfigurationException("Unable to start embedded Neo4j server: " + e.getMessage(), e);
                }
            }
        }
        return configuration;
    }

    public static ServerControls start(File dataLocation) throws IOException {
        return EmbeddedNeo4jServer.attemptStartServer(0, dataLocation, Collections.emptyMap());
    }

    public static ServerControls start(File dataLocation, Map<String, Object> options) throws IOException {
        return EmbeddedNeo4jServer.attemptStartServer(0, dataLocation, options);
    }

    public static ServerControls start(InetSocketAddress inetAddr) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), null);
    }

    public static ServerControls start(InetSocketAddress inetAddr, File dataLocation) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), dataLocation);
    }

    public static ServerControls start(InetSocketAddress inetAddr, File dataLocation, Map<String, Object> options) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), dataLocation, options);
    }

    public static ServerControls start(String address) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(new InetSocketAddress(uri.getHost(), uri.getPort()));
    }

    public static ServerControls start(String address, File dataLocation) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataLocation);
    }

    public static ServerControls start(String address, File dataLocation, Map<String, Object> options) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataLocation, options);
    }

    public static ServerControls start(String host, int port) {
        return EmbeddedNeo4jServer.start(host, port, null);
    }

    public static ServerControls start(String host, int port, File dataLocation) {
        return EmbeddedNeo4jServer.start(host, port, dataLocation, Collections.emptyMap());
    }

    public static ServerControls start(String host, int port, File dataLocation, Map<String, Object> options) {
        String myBoltAddress = String.format("%s:%d", host, port);
        TestServerBuilder serverBuilder = TestServerBuilders.newInProcessBuilder().withConfig(new BoltConnector((String)"0").enabled, "true").withConfig(new BoltConnector((String)"0").type, Connector.ConnectorType.BOLT.name()).withConfig(new BoltConnector((String)"0").encryption_level, BoltConnector.EncryptionLevel.DISABLED.name()).withConfig(new BoltConnector((String)"0").listen_address, myBoltAddress);
        if (dataLocation != null) {
            serverBuilder = serverBuilder.withConfig(GraphDatabaseSettings.data_directory, dataLocation.getPath());
        }
        for (String name : options.keySet()) {
            serverBuilder.withConfig(name, options.get(name).toString());
        }
        return serverBuilder.newServer();
    }

    private static ServerControls attemptStartServer(int retryCount, File dataLocation, Map<String, Object> options) throws IOException {
        try {
            return EmbeddedNeo4jServer.start("localhost", 0, dataLocation, options);
        }
        catch (ServerStartupException sse) {
            if (retryCount < 4) {
                return EmbeddedNeo4jServer.attemptStartServer(++retryCount, dataLocation, options);
            }
            throw sse;
        }
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        if (this.serverControls != null) {
            this.serverControls.close();
        }
    }
}

