/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.neo4j.bolt;

import io.micronaut.core.util.StringUtils;
import io.micronaut.neo4j.bolt.Neo4jBoltConfiguration;
import io.micronaut.retry.annotation.Retryable;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Optional;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.exceptions.ServiceUnavailableException;

@Singleton
public class Neo4jDriverBuilder {
    private final Neo4jBoltConfiguration boltConfiguration;

    public Neo4jDriverBuilder(Neo4jBoltConfiguration boltConfiguration) {
        if (boltConfiguration == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this.boltConfiguration = boltConfiguration;
    }

    @Retryable(value={ServiceUnavailableException.class})
    public Driver buildDriver() {
        String[] info;
        Neo4jBoltConfiguration configuration = this.boltConfiguration;
        Optional<AuthToken> configuredAuthToken = configuration.getAuthToken();
        AuthToken authToken = configuredAuthToken.orElse(null);
        URI uri = configuration.getUri();
        String userInfo = uri.getUserInfo();
        if (authToken == null && StringUtils.hasText((CharSequence)userInfo) && (info = userInfo.split(":")).length == 2) {
            authToken = AuthTokens.basic((String)info[0], (String)info[1]);
        }
        return GraphDatabase.driver((URI)uri, (AuthToken)authToken, (Config)configuration.getConfig());
    }
}

