/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.neo4j.bolt.health;

import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.neo4j.driver.Driver;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.summary.ServerInfo;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

@Requires(classes={HealthIndicator.class})
@Singleton
public class Neo4jHealthIndicator
implements HealthIndicator {
    public static final String NAME = "neo4j";
    private final Driver boltDriver;
    private final ExecutorService ioExecutor;

    public Neo4jHealthIndicator(Driver boltDriver, @Named(value="io") ExecutorService ioExecutor) {
        this.boltDriver = boltDriver;
        this.ioExecutor = ioExecutor;
    }

    public Publisher<HealthResult> getResult() {
        try {
            Mono healthResultSingle = Mono.create(emitter -> {
                AsyncSession session = this.boltDriver.asyncSession();
                CompletionStage query = session.writeTransactionAsync(tx -> tx.runAsync("RETURN 1 AS result").thenCompose(ResultCursor::consumeAsync));
                query.handleAsync((resultSummaryStage, throwable) -> {
                    if (throwable != null) {
                        return this.buildErrorResult((Throwable)throwable);
                    }
                    HealthResult.Builder status = HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.UP);
                    ServerInfo serverInfo = resultSummaryStage.server();
                    status.details(Collections.singletonMap("server", serverInfo.agent() + "@" + serverInfo.address()));
                    return status.build();
                }).thenComposeAsync(status -> session.closeAsync().handle((signal, throwable) -> status)).thenAccept(arg_0 -> ((MonoSink)emitter).success(arg_0));
            });
            return healthResultSingle.subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.ioExecutor));
        }
        catch (Throwable e) {
            return Mono.just((Object)this.buildErrorResult(e));
        }
    }

    private HealthResult buildErrorResult(Throwable throwable) {
        return HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.DOWN).exception(throwable).build();
    }
}

