/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.neo4j.bolt.embedded;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.neo4j.bolt.Neo4jBoltConfiguration;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.harness.Neo4j;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.Neo4jBuilders;
import org.neo4j.server.ServerStartupException;

@Deprecated(since="6.0.2", forRemoval=true)
@Singleton
@Requires(classes={Neo4j.class})
public class EmbeddedNeo4jServer
implements BeanCreatedEventListener<Neo4jBoltConfiguration>,
Closeable {
    private static final int RETRY_COUNT_MAX = 4;
    private Neo4j serverControls;

    public Neo4jBoltConfiguration onCreated(BeanCreatedEvent<Neo4jBoltConfiguration> event) {
        Neo4jBoltConfiguration configuration = (Neo4jBoltConfiguration)event.getBean();
        URI uri = configuration.getUri();
        int port = uri.getPort();
        Neo4jBoltConfiguration.Neo4jEmbeddedSettings embeddedSettings = configuration.getEmbeddedSettings();
        if (port > -1 && SocketUtils.isTcpPortAvailable((int)port) && embeddedSettings.isEnabled()) {
            File dataDir;
            String location = embeddedSettings.getDirectory().orElse(null);
            Map<String, Object> options = embeddedSettings.getOptions();
            try {
                dataDir = location != null ? new File(location) : (embeddedSettings.isEphemeral() ? File.createTempFile("neo4j-temporary-data", "-tempdir") : new File("data/neo4j"));
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to create Neo4j temporary data directory: " + e.getMessage(), (Throwable)e);
            }
            if (embeddedSettings.isDropData() || embeddedSettings.isEphemeral()) {
                dataDir.delete();
            }
            if (embeddedSettings.isEphemeral()) {
                dataDir.deleteOnExit();
            }
            try {
                this.serverControls = EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataDir, options);
                URI boltURI = this.serverControls.boltURI();
                configuration.setUri(boltURI);
            }
            catch (Throwable e) {
                throw new ConfigurationException("Unable to start embedded Neo4j server: " + e.getMessage(), e);
            }
        }
        return configuration;
    }

    public static Neo4j start(File dataLocation) throws IOException {
        return EmbeddedNeo4jServer.attemptStartServer(0, dataLocation, Collections.emptyMap());
    }

    public static Neo4j start(File dataLocation, Map<String, Object> options) throws IOException {
        return EmbeddedNeo4jServer.attemptStartServer(0, dataLocation, options);
    }

    public static Neo4j start(InetSocketAddress inetAddr) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), null);
    }

    public static Neo4j start(InetSocketAddress inetAddr, File dataLocation) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), dataLocation);
    }

    public static Neo4j start(InetSocketAddress inetAddr, File dataLocation, Map<String, Object> options) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), dataLocation, options);
    }

    public static Neo4j start(String address) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(new InetSocketAddress(uri.getHost(), uri.getPort()));
    }

    public static Neo4j start(String address, File dataLocation) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataLocation);
    }

    public static Neo4j start(String address, File dataLocation, Map<String, Object> options) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataLocation, options);
    }

    public static Neo4j start(String host, int port) {
        return EmbeddedNeo4jServer.start(host, port, null);
    }

    public static Neo4j start(String host, int port, File dataLocation) {
        return EmbeddedNeo4jServer.start(host, port, dataLocation, Collections.emptyMap());
    }

    public static Neo4j start(String host, int port, File dataLocation, Map<String, Object> options) {
        Neo4jBuilder neo4jBuilder = (Neo4jBuilder)((Neo4jBuilder)((Neo4jBuilder)Neo4jBuilders.newInProcessBuilder().withConfig(BoltConnector.enabled, (Object)true)).withConfig(BoltConnector.encryption_level, (Object)BoltConnector.EncryptionLevel.DISABLED)).withConfig(BoltConnector.listen_address, (Object)new SocketAddress(host, port));
        if (dataLocation != null) {
            neo4jBuilder = (Neo4jBuilder)neo4jBuilder.withConfig(GraphDatabaseSettings.data_directory, (Object)dataLocation.toPath());
        }
        for (String name : options.keySet()) {
            Setting setting = SettingImpl.newBuilder((String)name, (SettingValueParser)SettingValueParsers.STRING, (Object)options.get(name).toString()).build();
            neo4jBuilder.withConfig(setting, (Object)options.get(name).toString());
        }
        return neo4jBuilder.build();
    }

    private static Neo4j attemptStartServer(int retryCount, File dataLocation, Map<String, Object> options) throws IOException {
        try {
            return EmbeddedNeo4jServer.start("localhost", 0, dataLocation, options);
        }
        catch (ServerStartupException sse) {
            if (retryCount < 4) {
                return EmbeddedNeo4jServer.attemptStartServer(++retryCount, dataLocation, options);
            }
            throw sse;
        }
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        if (this.serverControls != null) {
            this.serverControls.close();
        }
    }
}

