/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.archaius1;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.commons.configuration.AbstractConfiguration;

@Singleton
public class EnvironmentConfiguration
extends AbstractConfiguration
implements ApplicationEventListener<RefreshEvent> {
    private final Environment environment;

    public EnvironmentConfiguration(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected void addPropertyDirect(String key, Object value) {
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(String key) {
        return this.environment.containsProperty(NameUtils.hyphenate((String)key));
    }

    public Object getProperty(String key) {
        return this.environment.getProperty(NameUtils.hyphenate((String)key), Object.class).orElse(null);
    }

    public Iterator<String> getKeys() {
        final Iterator propertySourceIterator = this.environment.getPropertySources().iterator();
        if (!propertySourceIterator.hasNext()) {
            return Collections.emptyIterator();
        }
        return new Iterator<String>(){
            Iterator<String> i;
            {
                this.i = ((PropertySource)propertySourceIterator.next()).iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.i.hasNext()) {
                    return true;
                }
                if (propertySourceIterator.hasNext()) {
                    this.i = ((PropertySource)propertySourceIterator.next()).iterator();
                }
                return this.i.hasNext();
            }

            @Override
            public String next() {
                return this.i.next();
            }
        };
    }

    public void onApplicationEvent(RefreshEvent event) {
        Map changedProperties = event.getSource();
        for (Map.Entry entry : changedProperties.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                this.fireEvent(2, (String)entry.getKey(), null, false);
                continue;
            }
            this.fireEvent(3, (String)entry.getKey(), value, false);
        }
    }
}

