/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.archaius1;

import com.netflix.config.ConfigurationBasedDeploymentContext;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicPropertyFactory;
import io.micronaut.configuration.archaius1.EnvironmentConfiguration;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.event.ServiceReadyEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration.AbstractConfiguration;

@Context
public class EnvironmentDeploymentContext
implements DeploymentContext,
ApplicationEventListener<ServiceReadyEvent>,
Closeable {
    private final Environment environment;
    private ServiceInstance instance;
    private Map<DeploymentContext.ContextKey, String> customSettings = new ConcurrentHashMap<DeploymentContext.ContextKey, String>();

    public EnvironmentDeploymentContext(EnvironmentConfiguration environment) {
        this.environment = environment.getEnvironment();
        if (!ConfigurationManager.isConfigurationInstalled()) {
            ConfigurationManager.install((AbstractConfiguration)environment);
        }
    }

    public String getDeploymentEnvironment() {
        if (this.customSettings.containsKey(DeploymentContext.ContextKey.environment)) {
            return this.customSettings.get(DeploymentContext.ContextKey.environment);
        }
        Set activeNames = this.environment.getActiveNames();
        if (!activeNames.isEmpty()) {
            return (String)activeNames.iterator().next();
        }
        return "application";
    }

    public void setDeploymentEnvironment(String env) {
        this.setContextValue(DeploymentContext.ContextKey.environment, env);
    }

    public String getDeploymentDatacenter() {
        if (this.customSettings.containsKey(DeploymentContext.ContextKey.datacenter)) {
            return this.customSettings.get(DeploymentContext.ContextKey.datacenter);
        }
        if (this.instance != null) {
            return this.instance.getZone().orElse(null);
        }
        return null;
    }

    public void setDeploymentDatacenter(String deployedAt) {
        this.setContextValue(DeploymentContext.ContextKey.datacenter, deployedAt);
    }

    public String getApplicationId() {
        if (this.customSettings.containsKey(DeploymentContext.ContextKey.appId)) {
            return this.customSettings.get(DeploymentContext.ContextKey.appId);
        }
        if (this.instance != null) {
            return this.instance.getId();
        }
        return "application";
    }

    public void setApplicationId(String appId) {
        this.setContextValue(DeploymentContext.ContextKey.appId, appId);
    }

    public void setDeploymentServerId(String serverId) {
        this.setContextValue(DeploymentContext.ContextKey.serverId, serverId);
    }

    public String getDeploymentServerId() {
        if (this.customSettings.containsKey(DeploymentContext.ContextKey.serverId)) {
            return this.customSettings.get(DeploymentContext.ContextKey.serverId);
        }
        if (this.instance != null) {
            return this.instance.getInstanceId().orElse(null);
        }
        return null;
    }

    public String getDeploymentStack() {
        return this.customSettings.get(DeploymentContext.ContextKey.stack);
    }

    public String getValue(DeploymentContext.ContextKey key) {
        switch (key) {
            case appId: {
                return this.getApplicationId();
            }
            case zone: {
                return this.getZone();
            }
            case environment: {
                return this.getDeploymentEnvironment();
            }
            case stack: {
                return this.getDeploymentStack();
            }
            case region: {
                return this.getDeploymentRegion();
            }
            case serverId: {
                return this.getDeploymentServerId();
            }
            case datacenter: {
                return this.getDeploymentDatacenter();
            }
        }
        return null;
    }

    public void setValue(DeploymentContext.ContextKey key, String value) {
        switch (key) {
            case datacenter: {
                this.setDeploymentDatacenter(value);
                break;
            }
            case region: {
                this.setDeploymentRegion(value);
                break;
            }
            case stack: {
                this.setDeploymentStack(value);
                break;
            }
        }
    }

    public void setDeploymentStack(String stack) {
        this.setContextValue(DeploymentContext.ContextKey.stack, stack);
    }

    public String getDeploymentRegion() {
        if (this.customSettings.containsKey(DeploymentContext.ContextKey.region)) {
            return this.customSettings.get(DeploymentContext.ContextKey.region);
        }
        if (this.instance != null) {
            return this.instance.getRegion().orElse(null);
        }
        return null;
    }

    public String getZone() {
        if (this.customSettings.containsKey(DeploymentContext.ContextKey.zone)) {
            return this.customSettings.get(DeploymentContext.ContextKey.zone);
        }
        if (this.instance != null) {
            return this.instance.getZone().orElse(null);
        }
        return null;
    }

    public void setDeploymentRegion(String region) {
        this.setContextValue(DeploymentContext.ContextKey.region, region);
    }

    public void onApplicationEvent(ServiceReadyEvent event) {
        this.instance = event.getSource();
        ConfigurationManager.setDeploymentContext((DeploymentContext)this);
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        ReflectionUtils.setFieldIfPossible(ConfigurationManager.class, (String)"instance", null);
        ReflectionUtils.setFieldIfPossible(DynamicPropertyFactory.class, (String)"config", null);
        ReflectionUtils.setFieldIfPossible(ConfigurationManager.class, (String)"configMBean", null);
        ReflectionUtils.setFieldIfPossible(ConfigurationManager.class, (String)"context", (Object)new ConfigurationBasedDeploymentContext());
        ReflectionUtils.setFieldIfPossible(ConfigurationManager.class, (String)"customConfigurationInstalled", (Object)false);
    }

    private void setContextValue(DeploymentContext.ContextKey key, String env) {
        if (env == null) {
            this.customSettings.remove(key);
        } else {
            this.customSettings.put(key, env);
        }
    }
}

