/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hystrix;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import io.micronaut.context.annotation.Context;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

@Context
public class HystrixConfiguration
implements Closeable {
    public static final String HYSTRIX_STREAM_ENABLED = "hystrix.stream.enabled";

    public HystrixConfiguration() {
        HystrixPlugins.reset();
    }

    @Inject
    void setCommandExecutationHook(@Nullable HystrixCommandExecutionHook commandExecutionHook) {
        if (commandExecutionHook != null) {
            HystrixPlugins instance = HystrixPlugins.getInstance();
            instance.registerCommandExecutionHook(commandExecutionHook);
        }
    }

    @Inject
    void setEventNotifiers(@Nullable HystrixEventNotifier eventNotifier) {
        if (eventNotifier != null) {
            HystrixPlugins instance = HystrixPlugins.getInstance();
            instance.registerEventNotifier(eventNotifier);
        }
    }

    @Inject
    void setConcurrencyStrategy(@Nullable HystrixConcurrencyStrategy concurrencyStrategy) {
        if (concurrencyStrategy != null) {
            HystrixPlugins instance = HystrixPlugins.getInstance();
            instance.registerConcurrencyStrategy(concurrencyStrategy);
        }
    }

    @Inject
    void setMetricsPublisher(@Nullable HystrixMetricsPublisher metricsPublisher) {
        if (metricsPublisher != null) {
            HystrixPlugins instance = HystrixPlugins.getInstance();
            instance.registerMetricsPublisher(metricsPublisher);
        }
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        Hystrix.reset();
    }
}

