/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.configuration.hystrix.annotation.Hystrix;
import io.micronaut.configuration.hystrix.annotation.HystrixCommand;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.retry.intercept.RecoveryInterceptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.inject.Singleton;
import rx.Observable;
import rx.SingleSubscriber;

@Singleton
public class HystrixInterceptor
implements MethodInterceptor<Object, Object> {
    public static final String ATTRIBUTE_COMMAND = "hystrix.command";
    public static final String ATTRIBUTE_GROUP = "hystrix.group";
    public static final int POSITION = InterceptPhase.RETRY.getPosition() + 10;
    private final Map<ExecutableMethod, HystrixCommand.Setter> setterMap = new ConcurrentHashMap<ExecutableMethod, HystrixCommand.Setter>();
    private final Map<ExecutableMethod, HystrixObservableCommand.Setter> observableSetterMap = new ConcurrentHashMap<ExecutableMethod, HystrixObservableCommand.Setter>();
    private final RecoveryInterceptor recoveryInterceptor;

    public HystrixInterceptor(RecoveryInterceptor recoveryInterceptor) {
        this.recoveryInterceptor = recoveryInterceptor;
    }

    public int getOrder() {
        return POSITION;
    }

    public Object intercept(final MethodInvocationContext<Object, Object> context) {
        Class<HystrixCommand> annotationType = HystrixCommand.class;
        AnnotationValue settings = context.getAnnotation(Hystrix.class);
        AnnotationValue cmd = context.getAnnotation(annotationType);
        if (cmd == null) {
            return context.proceed();
        }
        String hystrixGroup = this.resolveHystrixGroup(context, (AnnotationValue<Hystrix>)settings);
        String commandName = cmd.stringValue().orElse(context.getMethodName());
        String threadPool = settings != null ? (String)settings.stringValue("threadPool").orElse(null) : null;
        final boolean wrapExceptions = settings != null ? settings.booleanValue("wrapExceptions").orElse(true) : true;
        ReturnType returnType = context.getReturnType();
        final Class javaReturnType = returnType.getType();
        context.setAttribute((CharSequence)ATTRIBUTE_GROUP, (Object)hystrixGroup);
        context.setAttribute((CharSequence)ATTRIBUTE_COMMAND, (Object)commandName);
        final boolean isFuture = CompletableFuture.class.isAssignableFrom(javaReturnType);
        if (Publishers.isConvertibleToPublisher((Class)javaReturnType) || isFuture) {
            HystrixObservableCommand.Setter setter = this.observableSetterMap.computeIfAbsent(context.getExecutableMethod(), method -> this.buildObservableSetter(hystrixGroup, commandName, (AnnotationValue<Hystrix>)settings));
            HystrixObservableCommand<Object> command = new HystrixObservableCommand<Object>(setter){

                protected Observable<Object> construct() {
                    Object result = context.proceed();
                    if (isFuture) {
                        result = Publishers.fromCompletableFuture((CompletableFuture)((CompletableFuture)result));
                    }
                    return (Observable)ConversionService.SHARED.convert(result, Observable.class).orElseThrow(() -> new IllegalStateException("Unsupported Reactive type: " + javaReturnType));
                }

                protected boolean isFallbackUserDefined() {
                    return HystrixInterceptor.this.recoveryInterceptor.findFallbackMethod(context).isPresent();
                }

                protected Observable<Object> resumeWithFallback() {
                    Optional fallbackMethod = HystrixInterceptor.this.recoveryInterceptor.findFallbackMethod(context);
                    if (fallbackMethod.isPresent()) {
                        Optional converted;
                        MethodExecutionHandle handle = (MethodExecutionHandle)fallbackMethod.get();
                        Object result = handle.invoke(context.getParameterValues());
                        if (isFuture) {
                            result = Publishers.fromCompletableFuture((CompletableFuture)((CompletableFuture)result));
                        }
                        if ((converted = ConversionService.SHARED.convert(result, Observable.class)).isPresent()) {
                            return (Observable)converted.get();
                        }
                    }
                    return super.resumeWithFallback();
                }

                protected boolean shouldNotBeWrapped(Throwable underlying) {
                    return !wrapExceptions || super.shouldNotBeWrapped(underlying);
                }
            };
            if (isFuture) {
                final CompletableFuture future = new CompletableFuture();
                command.toObservable().toSingle().subscribe((SingleSubscriber)new SingleSubscriber<Object>(){

                    public void onSuccess(Object value) {
                        future.complete(value);
                    }

                    public void onError(Throwable error) {
                        future.completeExceptionally(error);
                    }
                });
                return future;
            }
            return ConversionService.SHARED.convert((Object)command.toObservable(), returnType.asArgument()).orElseThrow(() -> new IllegalStateException("Unsupported Reactive type: " + javaReturnType));
        }
        HystrixCommand.Setter setter = this.setterMap.computeIfAbsent(context.getExecutableMethod(), method -> this.buildSetter(hystrixGroup, commandName, threadPool, (AnnotationValue<Hystrix>)settings));
        com.netflix.hystrix.HystrixCommand<Object> hystrixCommand = new com.netflix.hystrix.HystrixCommand<Object>(setter){

            protected Object run() {
                return context.proceed();
            }

            protected String getFallbackMethodName() {
                return super.getFallbackMethodName();
            }

            protected boolean isFallbackUserDefined() {
                return HystrixInterceptor.this.recoveryInterceptor.findFallbackMethod(context).isPresent();
            }

            protected Object getFallback() {
                Optional fallbackMethod = HystrixInterceptor.this.recoveryInterceptor.findFallbackMethod(context);
                if (fallbackMethod.isPresent()) {
                    MethodExecutionHandle handle = (MethodExecutionHandle)fallbackMethod.get();
                    return handle.invoke(context.getParameterValues());
                }
                return super.getFallback();
            }

            protected boolean shouldNotBeWrapped(Throwable underlying) {
                return !wrapExceptions || super.shouldNotBeWrapped(underlying);
            }
        };
        try {
            return hystrixCommand.execute();
        }
        catch (Exception e) {
            Throwable cause;
            if (!wrapExceptions && e instanceof ExecutionException && (cause = e.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
    }

    private HystrixCommand.Setter buildSetter(String hystrixGroup, String commandName, String threadPool, AnnotationValue<Hystrix> settings) {
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)hystrixGroup));
        HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)commandName);
        setter.andCommandKey(commandKey);
        if (StringUtils.isNotEmpty((CharSequence)threadPool)) {
            setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)threadPool));
        }
        if (settings != null) {
            List threadPoolProps;
            List properties = settings.getAnnotations("commandProperties", Property.class);
            if (!properties.isEmpty()) {
                HystrixCommandProperties.Setter instance = this.buildCommandProperties(properties);
                setter.andCommandPropertiesDefaults(instance);
            }
            if (!(threadPoolProps = settings.getAnnotations("threadPoolProperties", Property.class)).isEmpty()) {
                HystrixThreadPoolProperties.Setter threadPoolPropsInstance = this.buildThreadPoolProperties(properties);
                setter.andThreadPoolPropertiesDefaults(threadPoolPropsInstance);
            }
        }
        return setter;
    }

    private HystrixCommandProperties.Setter buildCommandProperties(List<AnnotationValue<Property>> properties) {
        Class<HystrixCommandProperties.Setter> setterClass = HystrixCommandProperties.Setter.class;
        HystrixCommandProperties.Setter instance = HystrixCommandProperties.defaultSetter();
        return this.buildPropertiesDynamic(properties, setterClass, instance);
    }

    private HystrixThreadPoolProperties.Setter buildThreadPoolProperties(List<AnnotationValue<Property>> properties) {
        return this.buildPropertiesDynamic(properties, HystrixThreadPoolProperties.Setter.class, HystrixThreadPoolProperties.defaultSetter());
    }

    private <T> T buildPropertiesDynamic(List<AnnotationValue<Property>> properties, Class<T> setterClass, T instance) {
        for (AnnotationValue<Property> property : properties) {
            Optional converted;
            Method m;
            Class<?>[] parameterTypes;
            String methodName;
            Optional method;
            String value;
            String name = property.get((CharSequence)"name", String.class).orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)name) || !StringUtils.isNotEmpty((CharSequence)(value = (String)property.getValue(String.class).orElse(null))) || !(method = ReflectionUtils.findMethodsByName(setterClass, (String)(methodName = "with" + NameUtils.capitalize((String)name))).findFirst()).isPresent() || (parameterTypes = (m = (Method)method.get()).getParameterTypes()).length != 1 || !(converted = ConversionService.SHARED.convert((Object)value, parameterTypes[0])).isPresent()) continue;
            try {
                Object v = converted.get();
                ReflectionUtils.invokeMethod(instance, (Method)m, (Object[])new Object[]{v});
            }
            catch (Exception e) {
                throw new ConfigurationException("Invalid Hystrix Property: " + name);
            }
        }
        return instance;
    }

    private HystrixObservableCommand.Setter buildObservableSetter(String hystrixGroup, String commandName, AnnotationValue<Hystrix> settings) {
        List properties;
        HystrixObservableCommand.Setter setter = HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)hystrixGroup));
        HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)commandName);
        setter.andCommandKey(commandKey);
        if (settings != null && !(properties = settings.getAnnotations("commandProperties", Property.class)).isEmpty()) {
            HystrixCommandProperties.Setter instance = this.buildCommandProperties(properties);
            setter.andCommandPropertiesDefaults(instance);
        }
        return setter;
    }

    private String resolveHystrixGroup(MethodInvocationContext<Object, Object> context, AnnotationValue<Hystrix> settings) {
        Supplier<String> groupSupplier = () -> context.getValue("io.micronaut.http.client.Client", "id", String.class).orElse(context.getDeclaringType().getSimpleName());
        if (settings != null) {
            return settings.get((CharSequence)"group", String.class).orElseGet(groupSupplier);
        }
        return groupSupplier.get();
    }
}

