/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hystrix.stream;

import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.serial.SerialHystrixDashboardData;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.sse.Event;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

@Controller(value="${hystrix.stream.path:/hystrix.stream}")
@Requirements(value={@Requires(classes={SerialHystrixDashboardData.class, Flowable.class}), @Requires(property="hystrix.stream.enabled", value="true", defaultValue="false")})
public class HystrixStreamController {
    private final Duration interval;

    @Inject
    public HystrixStreamController(@Value(value="${hystrix.stream.interval:1s}") Duration interval) {
        this.interval = interval;
    }

    public HystrixStreamController() {
        this(Duration.ofSeconds(1L));
    }

    @Get(value="/", produces={"text/event-stream"})
    public Flowable<Event<String>> hystrixStream() {
        return Flowable.interval((long)this.interval.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).flatMap(num -> Flowable.create(eventEmitter -> {
            try {
                for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
                    eventEmitter.onNext((Object)Event.of((Object)SerialHystrixDashboardData.toJsonString((HystrixCommandMetrics)commandMetrics)));
                }
                for (HystrixThreadPoolMetrics threadPoolMetrics : HystrixThreadPoolMetrics.getInstances()) {
                    eventEmitter.onNext((Object)Event.of((Object)SerialHystrixDashboardData.toJsonString((HystrixThreadPoolMetrics)threadPoolMetrics)));
                }
                for (HystrixCollapserMetrics collapserMetrics : HystrixCollapserMetrics.getInstances()) {
                    eventEmitter.onNext((Object)Event.of((Object)SerialHystrixDashboardData.toJsonString((HystrixCollapserMetrics)collapserMetrics)));
                }
            }
            catch (Exception e) {
                eventEmitter.onError((Throwable)e);
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER));
    }
}

