/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.aws;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.objectstorage.configuration.AbstractObjectStorageConfiguration;
import jakarta.validation.constraints.Pattern;

@EachProperty(value="micronaut.object-storage.aws")
@Introspected
public class AwsS3Configuration
extends AbstractObjectStorageConfiguration {
    public static final String NAME = "aws";
    public static final String PREFIX = "micronaut.object-storage.aws";
    @NonNull
    @Pattern(regexp="(?!(^((2(5[0-5]|[0-4][0-9])|[01]?[0-9]{1,2})\\.){3}(2(5[0-5]|[0-4][0-9])|[01]?[0-9]{1,2})$|^xn--|.+-s3alias$|.*\\.\\.))^[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]$")
    private @NonNull @Pattern(regexp="(?!(^((2(5[0-5]|[0-4][0-9])|[01]?[0-9]{1,2})\\.){3}(2(5[0-5]|[0-4][0-9])|[01]?[0-9]{1,2})$|^xn--|.+-s3alias$|.*\\.\\.))^[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]$") String bucket;

    public AwsS3Configuration(@Parameter String name) {
        super(name);
    }

    @NonNull
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(@NonNull String bucket) {
        this.bucket = bucket;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

