/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.aws;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.objectstorage.ObjectStorageEntry;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class AwsS3ObjectStorageEntry
implements ObjectStorageEntry<GetObjectResponse> {
    @NonNull
    private final String key;
    @NonNull
    private final ResponseInputStream<GetObjectResponse> responseInputStream;

    public AwsS3ObjectStorageEntry(@NonNull String key, @NonNull ResponseInputStream<GetObjectResponse> responseInputStream) {
        this.responseInputStream = responseInputStream;
        this.key = key;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public InputStream getInputStream() {
        return this.responseInputStream;
    }

    @NonNull
    public GetObjectResponse getNativeEntry() {
        return (GetObjectResponse)this.responseInputStream.response();
    }

    @NonNull
    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(((GetObjectResponse)this.responseInputStream.response()).metadata());
    }

    @NonNull
    public Optional<String> getContentType() {
        return Optional.ofNullable(((GetObjectResponse)this.responseInputStream.response()).contentType());
    }
}

