/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.aws;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.objectstorage.InputStreamMapper;
import io.micronaut.objectstorage.ObjectStorageException;
import io.micronaut.objectstorage.ObjectStorageOperations;
import io.micronaut.objectstorage.aws.AwsS3Configuration;
import io.micronaut.objectstorage.aws.AwsS3ObjectStorageEntry;
import io.micronaut.objectstorage.configuration.ToggeableCondition;
import io.micronaut.objectstorage.request.BytesUploadRequest;
import io.micronaut.objectstorage.request.FileUploadRequest;
import io.micronaut.objectstorage.request.UploadRequest;
import io.micronaut.objectstorage.response.UploadResponse;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

@EachBean(value=AwsS3Configuration.class)
@Requirements(value={@Requires(condition=ToggeableCondition.class), @Requires(beans={AwsS3Configuration.class})})
public class AwsS3Operations
implements ObjectStorageOperations<PutObjectRequest.Builder, PutObjectResponse, DeleteObjectResponse> {
    private final S3Client s3Client;
    private final AwsS3Configuration configuration;
    private final InputStreamMapper inputStreamMapper;

    public AwsS3Operations(@Parameter AwsS3Configuration configuration, S3Client s3Client, InputStreamMapper inputStreamMapper) {
        this.s3Client = s3Client;
        this.configuration = configuration;
        this.inputStreamMapper = inputStreamMapper;
    }

    @NonNull
    public UploadResponse<PutObjectResponse> upload(@NonNull UploadRequest uploadRequest) {
        PutObjectRequest objectRequest = (PutObjectRequest)this.getRequestBuilder(uploadRequest).build();
        RequestBody requestBody = this.getRequestBody(uploadRequest);
        try {
            PutObjectResponse response = this.s3Client.putObject(objectRequest, requestBody);
            return UploadResponse.of((String)uploadRequest.getKey(), (String)response.eTag(), (Object)response);
        }
        catch (AwsServiceException | SdkClientException e) {
            String msg = String.format("Error when trying to upload a file with key [%s] to Amazon S3", uploadRequest.getKey());
            throw new ObjectStorageException(msg, e);
        }
    }

    @NonNull
    public UploadResponse<PutObjectResponse> upload(@NonNull UploadRequest request, @NonNull Consumer<PutObjectRequest.Builder> requestConsumer) {
        PutObjectRequest.Builder builder = this.getRequestBuilder(request);
        requestConsumer.accept(builder);
        RequestBody requestBody = this.getRequestBody(request);
        try {
            PutObjectResponse response = this.s3Client.putObject((PutObjectRequest)builder.build(), requestBody);
            return UploadResponse.of((String)request.getKey(), (String)response.eTag(), (Object)response);
        }
        catch (AwsServiceException | SdkClientException e) {
            String msg = String.format("Error when trying to upload a file with key [%s] to AWS S3", request.getKey());
            throw new ObjectStorageException(msg, e);
        }
    }

    @NonNull
    public Optional<AwsS3ObjectStorageEntry> retrieve(@NonNull String key) {
        try {
            ResponseInputStream responseInputStream = this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.configuration.getBucket()).key(key).build());
            AwsS3ObjectStorageEntry entry = new AwsS3ObjectStorageEntry(key, (ResponseInputStream<GetObjectResponse>)responseInputStream);
            return Optional.of(entry);
        }
        catch (NoSuchKeyException noSuchKeyException) {
            return Optional.empty();
        }
        catch (AwsServiceException | SdkClientException e) {
            String msg = String.format("Error when trying to retrieve a file with key [%s] from Amazon S3", key);
            throw new ObjectStorageException(msg, e);
        }
    }

    @NonNull
    public DeleteObjectResponse delete(@NonNull String key) {
        try {
            return this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.configuration.getBucket()).key(key).build());
        }
        catch (AwsServiceException | SdkClientException e) {
            String msg = String.format("Error when trying to delete a file with key [%s] from Amazon S3", key);
            throw new ObjectStorageException(msg, e);
        }
    }

    public boolean exists(@NonNull String key) {
        try {
            this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.configuration.getBucket()).key(key).build());
            return true;
        }
        catch (NoSuchKeyException noSuchKeyException) {
            return false;
        }
        catch (AwsServiceException | SdkClientException e) {
            String msg = String.format("Error when trying to check the existence of a file with key [%s] in Amazon S3", key);
            throw new ObjectStorageException(msg, e);
        }
    }

    @NonNull
    public Set<String> listObjects() {
        String bucket = this.configuration.getBucket();
        try {
            ListObjectsResponse response = this.s3Client.listObjects(b -> b.bucket(bucket));
            return response.contents().stream().map(S3Object::key).collect(Collectors.toSet());
        }
        catch (NoSuchBucketException e) {
            return Collections.emptySet();
        }
        catch (AwsServiceException | SdkClientException e) {
            String msg = String.format("Error when listing the objects of the bucket [%s] in Amazon S3", bucket);
            throw new ObjectStorageException(msg, e);
        }
    }

    public void copy(@NonNull String sourceKey, @NonNull String destinationKey) {
        try {
            this.s3Client.copyObject((CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(this.configuration.getBucket()).destinationBucket(this.configuration.getBucket()).sourceKey(sourceKey).destinationKey(destinationKey).build());
        }
        catch (AwsServiceException | SdkClientException e) {
            String msg = String.format("Error when trying to copy a file from key [%s] to key [%s] in Amazon S3", sourceKey, destinationKey);
            throw new ObjectStorageException(msg, e);
        }
    }

    @NonNull
    protected PutObjectRequest.Builder getRequestBuilder(@NonNull UploadRequest request) {
        PutObjectRequest.Builder builder = PutObjectRequest.builder().bucket(this.configuration.getBucket()).key(request.getKey());
        request.getContentType().ifPresent(arg_0 -> ((PutObjectRequest.Builder)builder).contentType(arg_0));
        request.getContentSize().ifPresent(arg_0 -> ((PutObjectRequest.Builder)builder).contentLength(arg_0));
        if (CollectionUtils.isNotEmpty((Map)request.getMetadata())) {
            builder.metadata(request.getMetadata());
        }
        return builder;
    }

    @NonNull
    protected RequestBody getRequestBody(@NonNull UploadRequest uploadRequest) {
        if (uploadRequest instanceof FileUploadRequest) {
            FileUploadRequest request = (FileUploadRequest)uploadRequest;
            return RequestBody.fromFile((File)request.getFile());
        }
        if (uploadRequest instanceof BytesUploadRequest) {
            BytesUploadRequest request = (BytesUploadRequest)uploadRequest;
            return RequestBody.fromBytes((byte[])request.getBytes());
        }
        byte[] inputBytes = this.inputStreamMapper.toByteArray(uploadRequest.getInputStream());
        return RequestBody.fromBytes((byte[])inputBytes);
    }
}

