/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.objectstorage.azure.AzureBlobStorageConfiguration;

@Factory
public class AzureBlobStorageFactory {
    private final BeanContext beanContext;

    public AzureBlobStorageFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @EachBean(value=AzureBlobStorageConfiguration.class)
    @Requirements(value={@Requires(bean=TokenCredential.class), @Requires(missingBeans={StorageSharedKeyCredential.class})})
    public BlobServiceClientBuilder blobServiceClientBuilderWithTokenCredential(AzureBlobStorageConfiguration configuration, @NonNull TokenCredential tokenCredential) {
        return new BlobServiceClientBuilder().endpoint(configuration.getEndpoint()).credential(tokenCredential);
    }

    @EachBean(value=AzureBlobStorageConfiguration.class)
    @Requires(bean=StorageSharedKeyCredential.class)
    public BlobServiceClientBuilder blobServiceClientBuilderWithSharedKeyCredential(AzureBlobStorageConfiguration configuration, @NonNull StorageSharedKeyCredential sharedKeyCredential) {
        return new BlobServiceClientBuilder().endpoint(configuration.getEndpoint()).credential(sharedKeyCredential);
    }

    @EachBean(value=BlobServiceClientBuilder.class)
    public BlobServiceClient blobServiceClient(@NonNull BlobServiceClientBuilder builder) {
        return builder.buildClient();
    }

    @EachBean(value=BlobServiceClient.class)
    public BlobContainerClient blobContainerClient(@Parameter String name, @NonNull BlobServiceClient serviceClient) {
        AzureBlobStorageConfiguration configuration = (AzureBlobStorageConfiguration)((Object)this.beanContext.getBean(AzureBlobStorageConfiguration.class, Qualifiers.byName((String)name)));
        return serviceClient.getBlobContainerClient(configuration.getContainer());
    }
}

