/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.azure;

import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.objectstorage.ObjectStorageException;
import io.micronaut.objectstorage.ObjectStorageOperations;
import io.micronaut.objectstorage.azure.AzureBlobStorageEntry;
import io.micronaut.objectstorage.request.UploadRequest;
import io.micronaut.objectstorage.response.UploadResponse;
import jakarta.inject.Singleton;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.function.Consumer;

@EachBean(value=BlobContainerClient.class)
@Singleton
public class AzureBlobStorageOperations
implements ObjectStorageOperations<BlobParallelUploadOptions, BlockBlobItem, Response<Void>> {
    private final BlobContainerClient blobContainerClient;

    public AzureBlobStorageOperations(@Parameter BlobContainerClient blobContainerClient) {
        this.blobContainerClient = blobContainerClient;
    }

    @NonNull
    public UploadResponse<BlockBlobItem> upload(@NonNull UploadRequest request) {
        BlobParallelUploadOptions options = this.getUploadOptions(request);
        return this.doUpload(request, options);
    }

    @NonNull
    public UploadResponse<BlockBlobItem> upload(@NonNull UploadRequest request, @NonNull Consumer<BlobParallelUploadOptions> requestConsumer) {
        BlobParallelUploadOptions options = this.getUploadOptions(request);
        requestConsumer.accept(options);
        return this.doUpload(request, options);
    }

    @NonNull
    public Optional<AzureBlobStorageEntry> retrieve(@NonNull String key) {
        BlobClient blobClient = this.blobContainerClient.getBlobClient(key);
        AzureBlobStorageEntry storageEntry = null;
        if (Boolean.TRUE.equals(blobClient.exists())) {
            try {
                BinaryData data = blobClient.getBlockBlobClient().downloadContent();
                storageEntry = new AzureBlobStorageEntry(key, data);
            }
            catch (UncheckedIOException e) {
                throw new ObjectStorageException("Error when trying to retrieve a file from Azure Blob Storage", (Throwable)e);
            }
        }
        return Optional.ofNullable(storageEntry);
    }

    @NonNull
    public Response<Void> delete(@NonNull String key) {
        BlobClient blobClient = this.blobContainerClient.getBlobClient(key);
        return blobClient.getBlockBlobClient().deleteWithResponse(null, null, null, Context.NONE);
    }

    @NonNull
    protected BlobParallelUploadOptions getUploadOptions(@NonNull UploadRequest request) {
        return new BlobParallelUploadOptions(request.getInputStream()).setRequestConditions(new BlobRequestConditions().setIfNoneMatch("*"));
    }

    private UploadResponse<BlockBlobItem> doUpload(@NonNull UploadRequest request, @NonNull BlobParallelUploadOptions options) {
        BlobClient blobClient = this.blobContainerClient.getBlobClient(request.getKey());
        Response response = blobClient.uploadWithResponse(options, null, Context.NONE);
        return UploadResponse.of((String)request.getKey(), (String)((BlockBlobItem)response.getValue()).getETag(), (Object)((BlockBlobItem)response.getValue()));
    }
}

