/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.local;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.objectstorage.ObjectStorageEntry;
import io.micronaut.objectstorage.ObjectStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public class LocalStorageEntry
implements ObjectStorageEntry<Path> {
    @NonNull
    private final String key;
    @NonNull
    private final Path file;
    @NonNull
    private final Map<String, String> metadata;

    public LocalStorageEntry(@NonNull String key, @NonNull Path file, @NonNull Map<String, String> metadata) {
        this.key = key;
        this.file = file;
        this.metadata = metadata;
    }

    public String getKey() {
        return this.key;
    }

    public InputStream getInputStream() {
        try {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ObjectStorageException("Error opening input stream for file: " + this.file, (Throwable)e);
        }
    }

    public Path getNativeEntry() {
        return this.file;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(URLConnection.guessContentTypeFromName(this.file.toFile().getName()));
    }
}

