/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.local;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.objectstorage.ObjectStorageException;
import io.micronaut.objectstorage.ObjectStorageOperations;
import io.micronaut.objectstorage.configuration.ToggeableCondition;
import io.micronaut.objectstorage.local.LocalStorageConfiguration;
import io.micronaut.objectstorage.local.LocalStorageEntry;
import io.micronaut.objectstorage.request.UploadRequest;
import io.micronaut.objectstorage.response.UploadResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@EachBean(value=LocalStorageConfiguration.class)
@Requirements(value={@Requires(condition=ToggeableCondition.class), @Requires(beans={LocalStorageConfiguration.class})})
@Primary
public class LocalStorageOperations
implements ObjectStorageOperations<LocalStorageFile, LocalStorageFile, LocalStorageFile> {
    public static final String METADATA_DIRECTORY = ".metadata";
    private final LocalStorageConfiguration configuration;
    private final Path metadataPath;

    public LocalStorageOperations(@Parameter LocalStorageConfiguration configuration) {
        this.configuration = configuration;
        this.metadataPath = configuration.getPath().resolve(METADATA_DIRECTORY);
        boolean metadataDirectoryCreated = this.mkdirs(this.metadataPath);
        if (!metadataDirectoryCreated) {
            throw new ObjectStorageException("Error creating metadata directory: " + this.metadataPath);
        }
    }

    @NonNull
    public UploadResponse<LocalStorageFile> upload(@NonNull UploadRequest request) {
        return this.upload(request, localStorageFile -> {});
    }

    @NonNull
    public UploadResponse<LocalStorageFile> upload(@NonNull UploadRequest request, @NonNull Consumer<LocalStorageFile> requestConsumer) {
        Path file = this.storeFile(request);
        this.storeMetadata(request);
        LocalStorageFile localFile = new LocalStorageFile(file);
        requestConsumer.accept(localFile);
        return UploadResponse.of((String)request.getKey(), (String)UUID.randomUUID().toString(), (Object)localFile);
    }

    @NonNull
    public Optional<LocalStorageEntry> retrieve(@NonNull String key) {
        Optional<Path> file = this.retrieveFile(key);
        return file.map(path -> new LocalStorageEntry(key, (Path)path, this.retrieveMetadata(key)));
    }

    @NonNull
    public LocalStorageFile delete(@NonNull String key) {
        Optional<Path> file = this.retrieveFile(key);
        this.deleteFile(key);
        this.deleteMetadata(key);
        return new LocalStorageFile(file.orElse(null));
    }

    public boolean exists(@NonNull String key) {
        return this.retrieveFile(key).isPresent();
    }

    @NonNull
    public Set<String> listObjects() {
        Set<String> set;
        block8: {
            Stream<Path> stream = Files.find(this.configuration.getPath(), Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);
            try {
                set = stream.map(p -> this.configuration.getPath().relativize((Path)p)).map(Path::toString).filter(s -> !s.startsWith(METADATA_DIRECTORY)).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ObjectStorageException("Error listing objects", (Throwable)e);
                }
            }
            stream.close();
        }
        return set;
    }

    public void copy(@NonNull String sourceKey, @NonNull String destinationKey) {
        this.retrieveFile(sourceKey).ifPresent(source -> {
            try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
                this.storeFile(destinationKey, in);
                this.storeMetadata(destinationKey, this.retrieveMetadata(sourceKey));
            }
            catch (IOException e) {
                throw new ObjectStorageException("Error copying file: " + source, (Throwable)e);
            }
        });
    }

    private Optional<Path> retrieveFile(String key) {
        Path file = LocalStorageOperations.resolveSafe(this.configuration.getPath(), key);
        if (Files.exists(file, new LinkOption[0])) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private Map<String, String> retrieveMetadata(String key) {
        Properties metadataProperties = new Properties();
        Path metadata = LocalStorageOperations.resolveSafe(this.metadataPath, key).normalize();
        if (Files.exists(metadata, new LinkOption[0])) {
            try (InputStream metadataIn2 = Files.newInputStream(metadata, new OpenOption[0]);){
                metadataProperties.load(metadataIn2);
            }
            catch (IOException metadataIn2) {
                // empty catch block
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(metadataProperties.size());
        for (String name : metadataProperties.stringPropertyNames()) {
            result.put(name, metadataProperties.getProperty(name));
        }
        return result;
    }

    private void deleteFile(String key) {
        this.retrieveFile(key).ifPresent(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new ObjectStorageException("Error deleting file: " + path, (Throwable)e);
            }
        });
    }

    private void deleteMetadata(String key) {
        Path metadata = LocalStorageOperations.resolveSafe(this.metadataPath, key);
        if (Files.exists(metadata, new LinkOption[0])) {
            try {
                Files.delete(metadata);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Path storeFile(UploadRequest request) {
        return this.storeFile(request.getKey(), request.getInputStream());
    }

    private Path storeFile(String key, InputStream inputStream) {
        Path path;
        block8: {
            Path file = LocalStorageOperations.resolveSafe(this.configuration.getPath(), key);
            this.mkdirs(file.getParent());
            OutputStream fileOut = Files.newOutputStream(file, new OpenOption[0]);
            try {
                inputStream.transferTo(fileOut);
                path = file;
                if (fileOut == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileOut != null) {
                        try {
                            fileOut.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ObjectStorageException("Error copying file to: " + file, (Throwable)e);
                }
            }
            fileOut.close();
        }
        return path;
    }

    private void storeMetadata(UploadRequest request) {
        this.storeMetadata(request.getKey(), request.getMetadata());
    }

    private void storeMetadata(String key, Map<String, String> metadata) {
        Properties metadataProperties = new Properties();
        metadataProperties.putAll(metadata);
        Path metadataFilePath = LocalStorageOperations.resolveSafe(this.metadataPath, key);
        this.mkdirs(metadataFilePath.getParent());
        try (FileOutputStream metadataOut = new FileOutputStream(metadataFilePath.toFile());){
            metadataProperties.store(metadataOut, "Metadata for file: " + key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean mkdirs(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static Path resolveSafe(Path parent, String key) {
        Path file = parent.resolve(key).normalize();
        if (!file.startsWith(parent)) {
            throw new IllegalArgumentException("Path lies outside the configured bucket");
        }
        return file;
    }

    record LocalStorageFile(Path path) {
    }
}

