/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.objectstorage.local;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.objectstorage.ObjectStorageException;
import io.micronaut.objectstorage.configuration.AbstractObjectStorageConfiguration;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@EachProperty(value="micronaut.object-storage.local")
public class LocalStorageConfiguration
extends AbstractObjectStorageConfiguration {
    public static final String NAME = "local";
    public static final String PREFIX = "micronaut.object-storage.local";
    @NonNull
    private Path path;

    public LocalStorageConfiguration(@Parameter String name) {
        super(name);
    }

    @NonNull
    public Path getPath() {
        if (this.path == null) {
            try {
                this.path = Files.createTempDirectory("micronaut-object-storage-local", new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new ObjectStorageException("Error creating temp directory for local storage", (Throwable)e);
            }
        }
        return this.path;
    }

    public void setPath(@NonNull Path path) {
        this.path = path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

