/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.adoc;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.adoc.md.MdToAdocConverter;
import io.micronaut.openapi.adoc.utils.SwaggerUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class OpenApiToAdocConverter {
    private static final String TEMPLATE_PREFIX = "template_";
    private static final String TEMPLATES_DIR = "/template";

    private OpenApiToAdocConverter() {
    }

    public static void convert() throws TemplateException, IOException {
        boolean fileExists;
        String openApiFile = System.getProperty("micronaut.openapi.adoc.openapi.path");
        if (openApiFile == null || openApiFile.isBlank()) {
            throw new IllegalArgumentException("OpenAPI file path not set");
        }
        OpenAPI openApi = SwaggerUtils.readOpenApiFromLocation(openApiFile);
        Path outputPath = Paths.get(System.getProperty("micronaut.openapi.adoc.output.dir", "build/generated"), new String[0]).resolve(System.getProperty("micronaut.openapi.adoc.output.filename", "openApiDoc.adoc"));
        if (outputPath.getParent() != null) {
            try {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed create directory", e);
            }
        }
        try (BufferedWriter writer = (fileExists = Files.exists(outputPath, new LinkOption[0])) ? Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, StandardOpenOption.APPEND) : Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            OpenApiToAdocConverter.convert(openApi, System.getProperties(), writer);
        }
    }

    public static void convert(OpenAPI openApi, Map props, Writer writer) throws TemplateException, IOException {
        MdToAdocConverter.convert(openApi);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("info", openApi.getInfo());
        model.put("externalDocs", openApi.getExternalDocs());
        model.put("servers", openApi.getServers());
        model.put("tags", openApi.getTags());
        model.put("openApi", openApi.getOpenapi());
        model.put("globalSecurityRequirements", openApi.getSecurity());
        model.put("paths", openApi.getPaths());
        model.put("components", openApi.getComponents());
        model.put(OpenApiToAdocConverter.template("definitions"), "definitions.ftl");
        model.put(OpenApiToAdocConverter.template("overview"), "overview.ftl");
        model.put(OpenApiToAdocConverter.template("paths"), "paths.ftl");
        model.put(OpenApiToAdocConverter.template("content"), "content.ftl");
        model.put(OpenApiToAdocConverter.template("examples"), "examples.ftl");
        model.put(OpenApiToAdocConverter.template("externalDocs"), "externalDocs.ftl");
        model.put(OpenApiToAdocConverter.template("headers"), "headers.ftl");
        model.put(OpenApiToAdocConverter.template("links"), "links.ftl");
        model.put(OpenApiToAdocConverter.template("parameters"), "parameters.ftl");
        model.put(OpenApiToAdocConverter.template("properties"), "properties.ftl");
        model.put(OpenApiToAdocConverter.template("propertyDescription"), "propertyDescription.ftl");
        model.put(OpenApiToAdocConverter.template("requestBody"), "requestBody.ftl");
        model.put(OpenApiToAdocConverter.template("responses"), "responses.ftl");
        model.put(OpenApiToAdocConverter.template("schemaType"), "schemaType.ftl");
        model.put(OpenApiToAdocConverter.template("securityRequirements"), "securityRequirements.ftl");
        model.put(OpenApiToAdocConverter.template("servers"), "servers.ftl");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("micronaut.openapi.adoc.templates.")) continue;
            model.put(key.replace("micronaut.openapi.adoc.templates.", TEMPLATE_PREFIX), entry.getValue());
        }
        String templateFilename = System.getProperty("micronaut.openapi.adoc.template.filename", "openApiDoc.ftl");
        String customTemplatesDirsStr = System.getProperty("micronaut.openapi.adoc.template.dir");
        String[] customTemplatesDirs = null;
        if (customTemplatesDirsStr != null && !customTemplatesDirsStr.isBlank()) {
            customTemplatesDirs = customTemplatesDirsStr.split(",");
        }
        Configuration cfg = OpenApiToAdocConverter.getFreemarkerConfig(customTemplatesDirs);
        Template template = cfg.getTemplate(templateFilename);
        template.process(model, writer);
    }

    private static Configuration getFreemarkerConfig(String[] customTemplatesDirs) throws IOException, TemplateModelException {
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(OpenApiToAdocConverter.class, TEMPLATES_DIR);
        if (customTemplatesDirs != null && customTemplatesDirs.length > 0) {
            ArrayList<Object> templateLoaders = new ArrayList<Object>();
            for (String templateDir : customTemplatesDirs) {
                if ((templateDir = templateDir.strip().replace("\\", "/")).startsWith("classpath:")) {
                    templateLoaders.add(new ClassTemplateLoader(OpenApiToAdocConverter.class, templateDir.substring("classpath:".length())));
                    continue;
                }
                if (templateDir.startsWith("file:") && (templateDir = templateDir.substring("file:".length())).startsWith("//")) {
                    templateDir = templateDir.substring(2);
                }
                templateLoaders.add(new FileTemplateLoader(new File(templateDir)));
            }
            templateLoaders.add(templateLoader);
            templateLoader = new MultiTemplateLoader(templateLoaders.toArray(new TemplateLoader[0]));
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setDefaultEncoding(StandardCharsets.UTF_8.displayName());
        cfg.setSharedVariable("JSON", (Object)OpenApiUtils.getJsonMapper());
        return cfg;
    }

    private static String template(String templateName) {
        return TEMPLATE_PREFIX + templateName;
    }
}

