/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.adoc.md;

import io.micronaut.openapi.adoc.md.ToAsciiDocSerializer;
import io.micronaut.openapi.adoc.utils.CollectionUtils;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.RootNode;

public final class MdToAdocConverter {
    private MdToAdocConverter() {
    }

    public static String convert(String markdown) {
        if (markdown == null || markdown.isBlank()) {
            return markdown;
        }
        PegDownProcessor processor = new PegDownProcessor(65535);
        if (markdown.contains("```")) {
            markdown = markdown.replaceAll("(?m)(?<!\n\n)(\\s*)```(\\w*\n)((?:\\1[^\n]*\n)+)\\1```", "\n$1```$2$3$1```");
        }
        RootNode rootNode = processor.parseMarkdown(markdown.toCharArray());
        return new ToAsciiDocSerializer(rootNode, markdown).toAsciiDoc();
    }

    public static void convert(OpenAPI openApi) {
        Paths paths;
        List tags;
        Info info = openApi.getInfo();
        if (info != null) {
            info.setDescription(MdToAdocConverter.convert(info.getDescription()));
            info.setTermsOfService(MdToAdocConverter.convert(info.getTermsOfService()));
        }
        MdToAdocConverter.processExternalDocs(openApi.getExternalDocs());
        List servers = openApi.getServers();
        if (CollectionUtils.isNotEmpty(servers)) {
            for (Server server : servers) {
                server.setDescription(MdToAdocConverter.convert(server.getDescription()));
                if (!CollectionUtils.isNotEmpty(server.getVariables())) continue;
                for (ServerVariable serverVar : server.getVariables().values()) {
                    serverVar.setDescription(MdToAdocConverter.convert(serverVar.getDescription()));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(tags = openApi.getTags())) {
            for (Tag tag : tags) {
                tag.setDescription(MdToAdocConverter.convert(tag.getDescription()));
                MdToAdocConverter.processExternalDocs(tag.getExternalDocs());
            }
        }
        if (CollectionUtils.isNotEmpty(paths = openApi.getPaths())) {
            for (PathItem path : paths.values()) {
                path.setSummary(MdToAdocConverter.convert(path.getSummary()));
                path.setDescription(MdToAdocConverter.convert(path.getDescription()));
                for (Operation operation : path.readOperations()) {
                    operation.setSummary(MdToAdocConverter.convert(operation.getSummary()));
                    operation.setDescription(MdToAdocConverter.convert(operation.getDescription()));
                    MdToAdocConverter.processExternalDocs(operation.getExternalDocs());
                    RequestBody requestBody = operation.getRequestBody();
                    if (requestBody != null) {
                        requestBody.setDescription(MdToAdocConverter.convert(requestBody.getDescription()));
                        MdToAdocConverter.processContent(requestBody.getContent());
                    }
                    if (CollectionUtils.isNotEmpty(operation.getParameters())) {
                        for (Parameter parameter : operation.getParameters()) {
                            MdToAdocConverter.processSchema(parameter.getSchema());
                            MdToAdocConverter.processExamples(parameter.getExamples());
                            MdToAdocConverter.processContent(parameter.getContent());
                            parameter.setDescription(MdToAdocConverter.convert(parameter.getDescription()));
                        }
                    }
                    MdToAdocConverter.processResponses((Map<String, ApiResponse>)operation.getResponses());
                }
            }
        }
        if (openApi.getComponents() != null) {
            MdToAdocConverter.processSchemas(openApi.getComponents().getSchemas());
            MdToAdocConverter.processResponses(openApi.getComponents().getResponses());
            if (CollectionUtils.isNotEmpty(openApi.getComponents().getParameters())) {
                MdToAdocConverter.processParameters(openApi.getComponents().getParameters().values());
            }
            MdToAdocConverter.processExamples(openApi.getComponents().getExamples());
            if (CollectionUtils.isNotEmpty(openApi.getComponents().getRequestBodies())) {
                MdToAdocConverter.processRequestBodies(openApi.getComponents().getRequestBodies().values());
            }
            MdToAdocConverter.processHeaders(openApi.getComponents().getHeaders());
            if (CollectionUtils.isNotEmpty(openApi.getComponents().getSecuritySchemes())) {
                MdToAdocConverter.processSecuritySchemas(openApi.getComponents().getSecuritySchemes().values());
            }
            MdToAdocConverter.processLinks(openApi.getComponents().getLinks());
        }
    }

    private static void processExternalDocs(ExternalDocumentation externalDocs) {
        if (externalDocs == null) {
            return;
        }
        externalDocs.setDescription(MdToAdocConverter.convert(externalDocs.getDescription()));
    }

    private static void processSchemas(Map<String, Schema> schemas) {
        if (CollectionUtils.isEmpty(schemas)) {
            return;
        }
        for (Schema schema : schemas.values()) {
            MdToAdocConverter.processSchema(schema);
        }
    }

    private static void processSchema(Schema schema) {
        if (schema == null) {
            return;
        }
        MdToAdocConverter.processExternalDocs(schema.getExternalDocs());
        schema.setDescription(MdToAdocConverter.convert(schema.getDescription()));
        MdToAdocConverter.processSchemas(schema.getProperties());
        MdToAdocConverter.processSchema(schema.getItems());
    }

    private static void processHeaders(Map<String, Header> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return;
        }
        for (Header header : headers.values()) {
            header.setDescription(MdToAdocConverter.convert(header.getDescription()));
            MdToAdocConverter.processExamples(header.getExamples());
            MdToAdocConverter.processSchema(header.getSchema());
            MdToAdocConverter.processContent(header.getContent());
        }
    }

    private static void processExamples(Map<String, Example> examples) {
        if (CollectionUtils.isEmpty(examples)) {
            return;
        }
        for (Example example : examples.values()) {
            example.setSummary(MdToAdocConverter.convert(example.getSummary()));
            example.setDescription(MdToAdocConverter.convert(example.getDescription()));
        }
    }

    private static void processContent(Content content) {
        if (content == null) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            MdToAdocConverter.processSchema(mediaType.getSchema());
            MdToAdocConverter.processExamples(mediaType.getExamples());
            MdToAdocConverter.processSchema(mediaType.getSchema());
            if (!CollectionUtils.isNotEmpty(mediaType.getEncoding())) continue;
            for (Encoding encoding : mediaType.getEncoding().values()) {
                MdToAdocConverter.processHeaders(encoding.getHeaders());
            }
        }
    }

    private static void processResponses(Map<String, ApiResponse> responses) {
        if (CollectionUtils.isEmpty(responses)) {
            return;
        }
        for (ApiResponse response : responses.values()) {
            MdToAdocConverter.processHeaders(response.getHeaders());
            MdToAdocConverter.processContent(response.getContent());
            response.setDescription(MdToAdocConverter.convert(response.getDescription()));
            MdToAdocConverter.processLinks(response.getLinks());
            if (!CollectionUtils.isNotEmpty(response.getLinks())) continue;
            for (Link link : response.getLinks().values()) {
                link.setDescription(MdToAdocConverter.convert(link.getDescription()));
            }
        }
    }

    private static void processLinks(Map<String, Link> links) {
        if (CollectionUtils.isEmpty(links)) {
            return;
        }
        for (Link link : links.values()) {
            link.setDescription(MdToAdocConverter.convert(link.getDescription()));
        }
    }

    private static void processParameters(Collection<Parameter> parameters) {
        if (CollectionUtils.isEmpty(parameters)) {
            return;
        }
        for (Parameter parameter : parameters) {
            MdToAdocConverter.processSchema(parameter.getSchema());
            MdToAdocConverter.processExamples(parameter.getExamples());
            MdToAdocConverter.processContent(parameter.getContent());
            parameter.setDescription(MdToAdocConverter.convert(parameter.getDescription()));
        }
    }

    private static void processRequestBodies(Collection<RequestBody> requestBodies) {
        if (CollectionUtils.isEmpty(requestBodies)) {
            return;
        }
        for (RequestBody requestBody : requestBodies) {
            requestBody.setDescription(MdToAdocConverter.convert(requestBody.getDescription()));
            MdToAdocConverter.processContent(requestBody.getContent());
        }
    }

    private static void processSecuritySchemas(Collection<SecurityScheme> securitySchemes) {
        if (CollectionUtils.isEmpty(securitySchemes)) {
            return;
        }
        for (SecurityScheme securityScheme : securitySchemes) {
            securityScheme.setDescription(MdToAdocConverter.convert(securityScheme.getDescription()));
        }
    }
}

