/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.adoc.md;

import io.micronaut.openapi.adoc.md.TableToAsciiDoc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.parboiled.common.Preconditions;
import org.pegdown.LinkRenderer;
import org.pegdown.Printer;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AbstractNode;
import org.pegdown.ast.AnchorLinkNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.Visitor;
import org.pegdown.ast.WikiLinkNode;

public class ToAsciiDocSerializer
implements Visitor {
    public static final String HARD_LINE_BREAK_MARKDOWN = "  \n";
    protected String source;
    protected Printer printer;
    protected final Map<String, ReferenceNode> references = new HashMap<String, ReferenceNode>();
    protected final Map<String, String> abbreviations = new HashMap<String, String>();
    protected final LinkRenderer linkRenderer = new LinkRenderer();
    protected TableNode currentTableNode;
    protected int currentTableColumn;
    protected boolean inTableHeader;
    protected char listMarker;
    protected int listLevel;
    protected int blockQuoteLevel;
    protected boolean autoDetectLanguageType = true;
    protected RootNode rootNode;

    public ToAsciiDocSerializer(RootNode rootNode, String source) {
        this.printer = new Printer();
        Preconditions.checkArgNotNull((Object)rootNode, (String)"rootNode");
        this.rootNode = rootNode;
        this.source = source;
    }

    public String toAsciiDoc() {
        this.cleanAst((Node)this.rootNode);
        this.rootNode.accept((Visitor)this);
        String result = this.normalizeWhitelines(this.printer.getString());
        this.printer.clear();
        return result;
    }

    public void visit(RootNode node) {
        for (ReferenceNode refNode : node.getReferences()) {
            this.visitChildren((AbstractNode)refNode);
            this.references.put(this.normalize(this.printer.getString()), refNode);
            this.printer.clear();
        }
        for (AbbreviationNode abbrNode : node.getAbbreviations()) {
            this.visitChildren((AbstractNode)abbrNode);
            String abbr = this.printer.getString();
            this.printer.clear();
            abbrNode.getExpansion().accept((Visitor)this);
            String expansion = this.printer.getString();
            this.abbreviations.put(abbr, expansion);
            this.printer.clear();
        }
        this.visitChildren((AbstractNode)node);
    }

    public void visit(AbbreviationNode node) {
    }

    public void visit(AnchorLinkNode node) {
        this.printer.print(node.getText());
    }

    public void visit(AutoLinkNode node) {
        this.printLink(this.linkRenderer.render(node));
    }

    public void visit(BlockQuoteNode node) {
        this.printer.println().println();
        this.blockQuoteLevel += 4;
        this.repeat('_', this.blockQuoteLevel);
        this.printer.println();
        this.visitChildren((AbstractNode)node);
        this.printer.println().println();
        this.repeat('_', this.blockQuoteLevel);
        this.blockQuoteLevel -= 4;
        this.printer.println();
    }

    public void visit(BulletListNode node) {
        char prevListMarker = this.listMarker;
        this.listMarker = (char)42;
        ++this.listLevel;
        this.visitChildren((AbstractNode)node);
        --this.listLevel;
        this.listMarker = prevListMarker;
    }

    public void visit(CodeNode node) {
        this.printer.print('`');
        this.printer.printEncoded(node.getText());
        this.printer.print('`');
    }

    public void visit(DefinitionListNode node) {
        this.printer.println();
        this.visitChildren((AbstractNode)node);
    }

    public void visit(DefinitionTermNode node) {
        this.visitChildren((AbstractNode)node);
        this.printer.indent(2);
        this.printer.print("::").println();
    }

    public void visit(DefinitionNode node) {
        this.visitChildren((AbstractNode)node);
        if (this.printer.indent > 0) {
            this.printer.indent(-2);
        }
        this.printer.println();
    }

    public void visit(ExpImageNode node) {
        String text = this.printChildrenToString((SuperNode)node);
        LinkRenderer.Rendering imageRenderer = this.linkRenderer.render(node, text);
        Node node2 = this.findParentNode((Node)node, (Node)this.rootNode);
        if (node2 instanceof ExpLinkNode) {
            ExpLinkNode expLinkNode = (ExpLinkNode)node2;
            this.printImageTagWithLink(imageRenderer, this.linkRenderer.render(expLinkNode, null));
        } else {
            this.printImageTag(this.linkRenderer.render(node, text));
        }
    }

    public void visit(ExpLinkNode node) {
        String text = this.printChildrenToString((SuperNode)node);
        if (text.startsWith("image:")) {
            this.printer.print(text);
        } else {
            this.printLink(this.linkRenderer.render(node, text));
        }
    }

    public void visit(HeaderNode node) {
        this.printer.println().println();
        this.repeat('=', node.getLevel());
        this.printer.print(' ');
        this.visitChildren((AbstractNode)node);
        this.printer.println().println();
    }

    private void repeat(char c, int times) {
        for (int i = 0; i < times; ++i) {
            this.printer.print(c);
        }
    }

    public void visit(HtmlBlockNode node) {
        String text = node.getText();
        if (!text.isEmpty()) {
            this.printer.println();
        }
        if (text.startsWith("<table")) {
            this.printer.print(TableToAsciiDoc.convert(text)).println();
        }
    }

    public void visit(InlineHtmlNode node) {
        this.printer.print(node.getText());
    }

    public void visit(ListItemNode node) {
        this.printer.println();
        this.repeat(this.listMarker, this.listLevel);
        this.printer.print(' ');
        this.visitChildren((AbstractNode)node);
    }

    public void visit(MailLinkNode node) {
        this.printLink(this.linkRenderer.render(node));
    }

    public void visit(OrderedListNode node) {
        char prevListMarker = this.listMarker;
        this.listMarker = (char)46;
        ++this.listLevel;
        this.visitChildren((AbstractNode)node);
        --this.listLevel;
        this.listMarker = prevListMarker;
    }

    public void visit(ParaNode node) {
        if (!this.isListItemText((Node)node)) {
            this.printer.println().println();
        }
        this.visitChildren((AbstractNode)node);
        this.printer.println().println();
    }

    public void visit(QuotedNode node) {
        switch (node.getType()) {
            case DoubleAngle: {
                this.printer.print("\u00ab");
                this.visitChildren((AbstractNode)node);
                this.printer.print("\u00bb");
                break;
            }
            case Double: {
                this.printer.print('\"');
                this.visitChildren((AbstractNode)node);
                this.printer.print('\"');
                break;
            }
            case Single: {
                this.printer.print('\'');
                this.visitChildren((AbstractNode)node);
                this.printer.print('\'');
            }
        }
    }

    public void visit(ReferenceNode node) {
    }

    public void visit(RefImageNode node) {
        String text = this.printChildrenToString((SuperNode)node);
        String key = node.referenceKey != null ? this.printChildrenToString(node.referenceKey) : text;
        ReferenceNode refNode = this.references.get(this.normalize(key));
        if (refNode == null) {
            this.printer.print("![").print(text).print(']');
            if (node.separatorSpace != null) {
                this.printer.print(node.separatorSpace).print('[');
                if (node.referenceKey != null) {
                    this.printer.print(key);
                }
                this.printer.print(']');
            }
        } else {
            this.printImageTag(this.linkRenderer.render(node, refNode.getUrl(), refNode.getTitle(), text));
        }
    }

    public void visit(RefLinkNode node) {
        String text = this.printChildrenToString((SuperNode)node);
        String key = node.referenceKey != null ? this.printChildrenToString(node.referenceKey) : text;
        ReferenceNode refNode = this.references.get(this.normalize(key));
        if (refNode == null) {
            this.printer.print('[').print(text).print(']');
            if (node.separatorSpace != null) {
                this.printer.print(node.separatorSpace).print('[');
                if (node.referenceKey != null) {
                    this.printer.print(key);
                }
                this.printer.print(']');
            }
        } else {
            this.printLink(this.linkRenderer.render(node, refNode.getUrl(), refNode.getTitle(), text));
        }
    }

    public void visit(SimpleNode node) {
        switch (node.getType()) {
            case Apostrophe: {
                this.printer.print('\'');
                break;
            }
            case Ellipsis: {
                this.printer.print("\u2026");
                break;
            }
            case Emdash: {
                this.printer.print("\u2014");
                break;
            }
            case Endash: {
                this.printer.print("\u2013");
                break;
            }
            case HRule: {
                this.printer.println().print("'''");
                break;
            }
            case Linebreak: {
                if (this.source != null && this.source.substring(node.getStartIndex(), node.getEndIndex()).startsWith(HARD_LINE_BREAK_MARKDOWN)) {
                    this.printer.print(" +").println();
                    break;
                }
                this.printer.println();
                break;
            }
            case Nbsp: {
                this.printer.print("{nbsp}");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void visit(StrongEmphSuperNode node) {
        if (node.isClosed()) {
            if (node.isStrong()) {
                this.printNodeSurroundedBy((AbstractNode)node, "*");
            } else {
                this.printNodeSurroundedBy((AbstractNode)node, "_");
            }
        } else {
            this.printer.print(node.getChars());
            this.visitChildren((AbstractNode)node);
        }
    }

    public void visit(StrikeNode node) {
        this.printer.print("[line-through]").print('#');
        this.visitChildren((AbstractNode)node);
        this.printer.print('#');
    }

    public void visit(TableBodyNode node) {
        this.visitChildren((AbstractNode)node);
    }

    public void visit(TableCaptionNode node) {
        this.printer.println().print("<caption>");
        this.visitChildren((AbstractNode)node);
        this.printer.print("</caption>");
    }

    public void visit(TableCellNode node) {
        List columns = this.currentTableNode.getColumns();
        TableColumnNode column = (TableColumnNode)columns.get(Math.min(this.currentTableColumn, columns.size() - 1));
        String pstr = this.printer.getString();
        if (!pstr.isEmpty()) {
            if (pstr.endsWith("\n") || pstr.endsWith(" ")) {
                this.printer.print('|');
            } else {
                this.printer.print(" |");
            }
        } else {
            this.printer.print('|');
        }
        column.accept((Visitor)this);
        if (node.getColSpan() > 1) {
            this.printer.print(" colspan=\"").print(Integer.toString(node.getColSpan())).print('\"');
        }
        this.visitChildren((AbstractNode)node);
        this.currentTableColumn += node.getColSpan();
    }

    public void visit(TableColumnNode node) {
    }

    public void visit(TableHeaderNode node) {
        this.inTableHeader = true;
        this.visitChildren((AbstractNode)node);
        this.inTableHeader = false;
    }

    private boolean ifColumnsHaveAlignmentSpecified(List<TableColumnNode> columns) {
        for (TableColumnNode column : columns) {
            if (column.getAlignment() == TableColumnNode.Alignment.None) continue;
            return true;
        }
        return false;
    }

    private String getColumnAlignment(List<TableColumnNode> columns) {
        ArrayList<String> result = new ArrayList<String>();
        block5: for (TableColumnNode column : columns) {
            switch (column.getAlignment()) {
                case None: 
                case Left: {
                    result.add("<");
                    continue block5;
                }
                case Right: {
                    result.add(">");
                    continue block5;
                }
                case Center: {
                    result.add("^");
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        return String.join((CharSequence)",", result);
    }

    public void visit(TableNode node) {
        this.currentTableNode = node;
        List columns = node.getColumns();
        if (this.ifColumnsHaveAlignmentSpecified(columns)) {
            this.printer.println().print("[cols=\"").print(this.getColumnAlignment(columns)).print("\"]").println();
        } else {
            this.printer.println();
        }
        this.printer.print("|===");
        this.visitChildren((AbstractNode)node);
        this.printer.println().print("|===").println();
        this.currentTableNode = null;
    }

    public void visit(TableRowNode node) {
        this.currentTableColumn = 0;
        this.printer.println();
        this.visitChildren((AbstractNode)node);
        if (this.inTableHeader) {
            this.printer.println();
        }
    }

    public void visit(VerbatimNode node) {
        this.printer.println();
        String type = node.getType();
        String text = node.getText();
        if ((type == null || type.isBlank()) && this.autoDetectLanguageType) {
            type = this.detectLanguage(text);
        }
        if (type != null && !type.isEmpty()) {
            this.printer.print("[source," + type + "]");
        }
        this.printer.println();
        this.repeat('-', 4);
        this.printer.println().print(text);
        this.repeat('-', 4);
        this.printer.println().println();
    }

    private String detectLanguage(String text) {
        if (text.startsWith("<")) {
            return "html";
        }
        if (text.endsWith(";")) {
            return "java";
        }
        if (text.contains("fun ")) {
            return "kotlin";
        }
        return "groovy";
    }

    public void visit(WikiLinkNode node) {
        this.printLink(this.linkRenderer.render(node));
    }

    public void visit(TextNode node) {
        if (this.abbreviations.isEmpty()) {
            this.printer.print(node.getText());
        } else {
            this.printWithAbbreviations(node.getText());
        }
    }

    public void visit(SpecialTextNode node) {
        this.printer.printEncoded(node.getText());
    }

    public void visit(SuperNode node) {
        this.visitChildren((AbstractNode)node);
    }

    public void visit(Node node) {
        throw new RuntimeException("Don't know how to handle node " + node);
    }

    protected void visitChildren(AbstractNode node) {
        for (Node child : node.getChildren()) {
            child.accept((Visitor)this);
        }
    }

    protected void cleanAst(Node node) {
        List children = node.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Node c = (Node)children.get(i);
            if (c instanceof RootNode) {
                children.set(i, (Node)c.getChildren().get(0));
            } else if (c.getClass().equals(SuperNode.class) && c.getChildren().size() == 1) {
                children.set(i, (Node)c.getChildren().get(0));
            }
            this.cleanAst(c);
        }
    }

    protected void printNodeSurroundedBy(AbstractNode node, String token) {
        this.printer.print(token);
        this.visitChildren(node);
        this.printer.print(token);
    }

    protected void printImageTag(LinkRenderer.Rendering rendering) {
        this.printer.print("image:").print(rendering.href).print('[');
        this.printTextWithQuotesIfNeeded(this.printer, rendering.text);
        this.printer.print(']');
    }

    protected void printImageTagWithLink(LinkRenderer.Rendering image, LinkRenderer.Rendering link) {
        this.printer.print("image:").print(image.href).print('[');
        if (image.text != null && !image.text.isEmpty()) {
            this.printTextWithQuotesIfNeeded(this.printer, image.text);
            this.printer.print(',');
        }
        this.printer.print("link=").print(link.href).print(']');
    }

    protected void printLink(LinkRenderer.Rendering rendering) {
        Object uri = rendering.href;
        String text = rendering.text;
        if (((String)uri).startsWith("#")) {
            this.printer.print("<<").print(((String)uri).substring(1)).print(',').print(text).print(">>");
        } else {
            if (!((String)uri).contains("://")) {
                uri = "link:" + (String)uri;
            }
            this.printer.print((String)uri);
            if (!((String)uri).equals(text)) {
                this.printer.print('[');
                this.printTextWithQuotesIfNeeded(this.printer, rendering.text);
                this.printer.print(']');
            }
        }
    }

    protected String printChildrenToString(SuperNode node) {
        Printer priorPrinter = this.printer;
        this.printer = new Printer();
        this.visitChildren((AbstractNode)node);
        String result = this.printer.getString();
        this.printer = priorPrinter;
        return result;
    }

    protected String normalize(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') continue;
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    protected String normalizeWhitelines(String text) {
        return text.replaceAll("(?m)^[ \t]*\r?\n{2,}", "\n").trim();
    }

    protected void printTextWithQuotesIfNeeded(Printer p, String text) {
        if (text != null && !text.isEmpty()) {
            if (text.contains(",")) {
                p.print('\"').print(text).print('\"');
            } else {
                p.print(text);
            }
        }
    }

    protected void printWithAbbreviations(String string) {
        TreeMap<Integer, Map.Entry<String, String>> expansions = null;
        for (Map.Entry<String, String> entry : this.abbreviations.entrySet()) {
            int sx;
            String abbr = entry.getKey();
            int ix = 0;
            while ((sx = string.indexOf(abbr, ix)) != -1) {
                ix = sx + abbr.length();
                if (sx > 0 && Character.isLetterOrDigit(string.charAt(sx - 1)) || ix < string.length() && Character.isLetterOrDigit(string.charAt(ix))) continue;
                if (expansions == null) {
                    expansions = new TreeMap<Integer, Map.Entry<String, String>>();
                }
                expansions.put(sx, entry);
            }
        }
        if (expansions != null) {
            int ix = 0;
            for (Map.Entry entry : expansions.entrySet()) {
                int sx = (Integer)entry.getKey();
                String abbr = (String)((Map.Entry)entry.getValue()).getKey();
                String expansion = (String)((Map.Entry)entry.getValue()).getValue();
                this.printer.printEncoded(string.substring(ix, sx)).print("<abbr");
                if (expansion != null && !expansion.isEmpty()) {
                    this.printer.print(" title=\"").printEncoded(expansion).print('\"');
                }
                this.printer.print('>').printEncoded(abbr).print("</abbr>");
                ix = sx + abbr.length();
            }
            this.printer.print(string.substring(ix));
        } else {
            this.printer.print(string);
        }
    }

    protected Node findParentNode(Node target, Node from) {
        if (target.equals(this.rootNode)) {
            return null;
        }
        for (Node c : from.getChildren()) {
            if (target.equals(c)) {
                return from;
            }
            Node candidate = this.findParentNode(target, c);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    protected boolean isFirstChild(Node parent, Node child) {
        return child.equals(parent.getChildren().get(0));
    }

    protected boolean isListItemText(Node node) {
        if (this.listLevel == 0) {
            return false;
        }
        Node parent = this.findParentNode(node, (Node)this.rootNode);
        return parent instanceof ListItemNode && this.isFirstChild(parent, node);
    }
}

