/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.adoc.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public final class FileUtils {
    public static final String FILE_SCHEME = "file:";
    public static final String CLASSPATH_SCHEME = "classpath:";

    private FileUtils() {
    }

    public static String loadFileFromClasspath(String location) {
        String file = location.replace("\\\\", "/");
        InputStream inputStream = FileUtils.class.getResourceAsStream(file);
        if (inputStream == null) {
            inputStream = FileUtils.class.getClassLoader().getResourceAsStream(file);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(file);
        }
        if (inputStream != null) {
            try {
                String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + file + " from the classpath", e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new RuntimeException("Could not find " + file + " on the classpath");
    }
}

