/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.adoc.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.adoc.utils.FileUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class SwaggerUtils {
    private SwaggerUtils() {
    }

    public static OpenAPI readOpenApi(String swaggerFileContent, boolean isJson) {
        ObjectMapper mapper = isJson ? OpenApiUtils.getJsonMapper() : OpenApiUtils.getYamlMapper();
        try {
            OpenAPI openApi = (OpenAPI)mapper.readValue(swaggerFileContent, OpenAPI.class);
            if (openApi.getOpenapi().equals("3.1.0")) {
                mapper = isJson ? OpenApiUtils.getJsonMapper31() : OpenApiUtils.getYamlMapper31();
                openApi = (OpenAPI)mapper.readValue(swaggerFileContent, OpenAPI.class);
            }
            return openApi;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Can't parse swagger file", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OpenAPI readOpenApiFromLocation(String location) {
        boolean isJson = location.endsWith(".json");
        String adjustedLocation = location.replace("\\\\", "/").toLowerCase();
        try {
            if (adjustedLocation.startsWith("jar:")) {
                try (InputStream in = new URI(adjustedLocation).toURL().openStream();){
                    OpenAPI openAPI = SwaggerUtils.readOpenApi(new String(in.readAllBytes(), StandardCharsets.UTF_8), isJson);
                    return openAPI;
                }
            }
            Path path = adjustedLocation.startsWith("file:") ? Paths.get(URI.create(adjustedLocation)) : Paths.get(adjustedLocation, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) return SwaggerUtils.readOpenApi(FileUtils.loadFileFromClasspath(adjustedLocation), isJson);
            return SwaggerUtils.readOpenApi(Files.readString(path), isJson);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read location `%s`".formatted(adjustedLocation), e);
        }
    }
}

