/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;

public class SchemaSerializer
extends JsonSerializer<Schema>
implements ResolvableSerializer {
    private JsonSerializer<Object> defaultSerializer;

    public SchemaSerializer(JsonSerializer<Object> serializer) {
        this.defaultSerializer = serializer;
    }

    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)this.defaultSerializer).resolve(serializerProvider);
        }
    }

    public void serialize(Schema value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.get$ref() == null || value.get$ref().isBlank()) {
            if (value.getExampleSetFlag() && value.getExample() == null) {
                jgen.writeStartObject();
                this.defaultSerializer.unwrappingSerializer(null).serialize((Object)value, jgen, provider);
                jgen.writeNullField("example");
                jgen.writeEndObject();
            } else {
                this.defaultSerializer.serialize((Object)value, jgen, provider);
            }
        } else {
            jgen.writeStartObject();
            jgen.writeStringField("$ref", value.get$ref());
            jgen.writeEndObject();
        }
    }
}

