/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import io.swagger.v3.oas.models.media.MediaType;
import java.io.IOException;

public class MediaTypeSerializer
extends JsonSerializer<MediaType>
implements ResolvableSerializer {
    private final JsonSerializer<Object> defaultSerializer;

    public MediaTypeSerializer(JsonSerializer<Object> serializer) {
        this.defaultSerializer = serializer;
    }

    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this.defaultSerializer;
        if (jsonSerializer instanceof ResolvableSerializer) {
            ResolvableSerializer resolvableSerializer = (ResolvableSerializer)jsonSerializer;
            resolvableSerializer.resolve(serializerProvider);
        }
    }

    public void serialize(MediaType value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.getExampleSetFlag() && value.getExample() == null) {
            jgen.writeStartObject();
            this.defaultSerializer.unwrappingSerializer(null).serialize((Object)value, jgen, provider);
            jgen.writeNullField("example");
            jgen.writeEndObject();
        } else {
            this.defaultSerializer.serialize((Object)value, jgen, provider);
        }
    }
}

